package com.pt.entity;

import jakarta.persistence.*;
import java.time.LocalDateTime;

@Entity
public class PeerInfoEntity {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long id;

    private String peerId;

    private String infoHash;
    private String ip;
    private int port;

    private LocalDateTime lastSeen;

    // 新增状态字段
    private String status; // "seeding", "downloading", "completed"
    private int isActive; // 是否活跃

    // 下载字段
    private long upload;        // 已上传量
    private long download;      // 已下载量     // 剩余下载量

    @Column(name = "download_left")
    private long left;

    public PeerInfoEntity(String ipAddress, int port, String peerId) {
        this.ip = ipAddress;
        this.port = port;
        this.peerId = peerId;
        this.lastSeen = LocalDateTime.now();
        this.status = "downloading"; // 默认状态为下载中
        this.isActive = 1; // 默认活跃状态
        this.upload = 0;
        this.download = 0;
    }

    public PeerInfoEntity() {

    }

    public long getId() {
        return id;
    }
    public void setId(long id) {
        this.id = id;
    }

    public String getInfoHash() {
        return infoHash;
    }

    public long getUploaded() {
        return upload;
    }

    public void setUploaded(long uploaded) {
        this.upload = uploaded;
    }

    public long getDownloaded() {
        return download;
    }

    public void setDownloaded(long downloaded) {
        this.download = downloaded;
    }

    public void setInfoHash(String infoHash) {
        this.infoHash = infoHash;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public LocalDateTime getLastSeen() {
        return lastSeen;
    }

    public void setLastSeen(LocalDateTime lastSeen) {
        this.lastSeen = lastSeen;
    }

    public String getPeerId() {
        return peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    // 新增状态字段的getter与setter
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int isActive() {
        return isActive;
    }

    public void setActive(int active) {
        isActive = active;
    }

    public void setIsActive(int isActive) {
        this.isActive = isActive;
    }

    public int getIsActive() {
        return isActive;
    }

    public long getLeft() {
        return left;
    }

    public void setLeft(long left) {
        this.left = left;
    }
}
