package com.pt.scheduler;

import com.pt.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 定时任务，用于定期更新用户的等级。
 */
@Component
public class UserLevelUpdateScheduler {

    private static final Logger logger = LoggerFactory.getLogger(UserLevelUpdateScheduler.class);

    @Autowired
    private UserService userService;

    /**
     * 使用CRON表达式定义任务执行时间。
     * "0 0 * * * ?" 表示在每个小时的整点（例如 01:00, 02:00）执行。
     * 该任务会调用服务来更新所有用户的等级。
     */
    @Scheduled(cron = "0 0 * * * ?")
    public void scheduleUserLevelUpdate() {
        logger.info("开始执行定时任务：更新所有用户等级...");
        try {
            userService.updateAllUsersLevel();
            logger.info("定时任务完成：所有用户等级已根据最新数据检查并更新。");
        } catch (Exception e) {
            logger.error("执行用户等级更新定时任务时发生错误", e);
        }
    }
} 