package com.pt.service;

import com.pt.entity.Comment;
import com.pt.repository.CommentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CommentService {

    @Autowired
    private CommentRepository commentRepository;

    public CommentService(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }

    public void addComment(String content, String username, int postId, Integer reviewer) {
        System.out.println("Adding comment: " + content + " by " + username + " on post ID: " + postId + " with reviewer ID: " + reviewer);
        Comment comment = new Comment();
        comment.setContent(content);
        comment.setWriter(username);
        comment.setParentPost(postId);
        if(reviewer != null) {
            System.out.println("Setting reviewer ID: " + reviewer);
            comment.setReviewer(reviewer);
        }
        commentRepository.save(comment);
    }

    public void deleteComment(int commentId) {
        commentRepository.deleteById(commentId);
    }

    public List<Comment> getCommentsByPostId(int postId) {
        List<Comment> comments = commentRepository.findByParentPost(postId);
        comments.sort(
                // Sort comments by publish date in descending order
                (c1, c2) -> c2.getPublishDate().compareTo(c1.getPublishDate())
        );
        return comments;
    }

    public Comment getCommentById(int commentId) {
        return commentRepository.findById(commentId).orElse(null);
    }
}
