package com.pt.service;

import com.pt.entity.TorrentMeta;
import com.pt.repository.TorrentMetaRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
public class TorrentMetaService {

    @Autowired
    private TorrentMetaRepository torrentMetaRepository;

    public void save(TorrentMeta torrentMeta) {
        // 这里可以添加保存逻辑，比如调用repository的save方法
        // torrentMetaRepository.save(torrentMeta);
        System.out.println("Saving TorrentMeta: " + torrentMeta);
    }

    public void save(String infoHash, String name, long size) {
        TorrentMeta torrentMeta = new TorrentMeta();
        torrentMeta.setInfoHash(infoHash);
        torrentMeta.setFilename(name);
        torrentMeta.setSize(size);
        torrentMeta.setUploadTime(LocalDateTime.now());
        torrentMetaRepository.save(torrentMeta);
    }
}
