package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.service.HelpCommentService;
import com.ptp.ptplatform.utils.Result;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/help/comments")
@AllArgsConstructor
public class HelpCommentController {

    private final HelpCommentService commentService;

    /**
     * 点赞评论
     * POST /help/comments/{commentId}/like
     */
    @PostMapping("/{commentId}/like")
    public Result like(@PathVariable int commentId) {
        commentService.incrementLike(commentId);
        return Result.ok();
    }
}