package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.service.SeedCommentService;
import com.ptp.ptplatform.utils.Result;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/seed/comments")
@AllArgsConstructor
public class SeedCommentController {
    private final SeedCommentService commentService;

    @PostMapping("/{commentId}/like")
    public Result like(@PathVariable int commentId) {
        commentService.incrementLike(commentId);
        return Result.ok();
    }
}