package com.ptp.ptplatform.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ptp.ptplatform.entity.HelpPost;
import com.ptp.ptplatform.entity.SeedComment;
import com.ptp.ptplatform.entity.SeedPost;
import com.ptp.ptplatform.service.SeedCommentService;
import com.ptp.ptplatform.service.SeedPostService;
import com.ptp.ptplatform.utils.Result;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

@RestController
@RequestMapping("/seed/posts")
@AllArgsConstructor
public class SeedPostController {
    private final SeedPostService postService;
    private final SeedCommentService commentService;

    // 创建帖子
    @PostMapping
    public Result createPost(@RequestBody SeedPost post) {
        postService.save(post);
        return Result.ok().data("post", post);
    }


    // 列表分页
    @GetMapping
    public Result listPosts(@RequestParam(defaultValue = "1") int page,
                            @RequestParam(defaultValue = "10") int size) {
        IPage<SeedPost> ipage = postService.page(
                new Page<>(page, size),
                new QueryWrapper<SeedPost>().orderByDesc("create_time")
        );
        return Result.ok()
                .data("records", ipage.getRecords())
                .data("total",    ipage.getTotal());
    }

    // 帖子详情 + 评论
    @GetMapping("/{postId}")
    public Result getPost(@PathVariable int postId) {
        SeedPost post = postService.getById(postId);
        List<SeedComment> comments = commentService.list(
                new QueryWrapper<SeedComment>()
                        .eq("post_id", postId)
                        .orderByAsc("create_time")
        );
        return Result.ok()
                .data("post",     post)
                .data("comments", comments);
    }

    // 点赞帖子
    @PostMapping("/{postId}/like")
    public Result likePost(@PathVariable int postId) {
        postService.incrementLike(postId);
        return Result.ok();
    }
    // 发布评论
    @PostMapping("/{postId}/comments")
    public Result comment(@PathVariable int postId,
                          @RequestBody SeedComment comment) {
        comment.setPostId(postId);
        commentService.save(comment);
        postService.incrementReplyCount(postId);
        return Result.ok()
                .data("commentId", comment.getId());
    }

    @Data
    @AllArgsConstructor
    static class SeedDetailResponse {
        private SeedPost post;
        private List<SeedComment> comments;
    }
}