//controller 文件夹中文件类似于view
// usermapper 实现用户登录注册等内容

package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.entity.*;
import com.ptp.ptplatform.mapper.UserMapper;
import com.ptp.ptplatform.mapper.InviteCodeMapper;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.*;
import com.ptp.ptplatform.utils.Result;
import com.ptp.ptplatform.utils.JwtUtils;
import com.ptp.ptplatform.entity.USER;
import java.util.Date;

@RestController
@RequestMapping("/user")
@CrossOrigin //启用跨域
public class UserController {

    @Resource
    private UserMapper userMapper;
    @Resource
    private InviteCodeMapper inviteCodeMapper;

    @GetMapping("/info") //获取
    public Result info(String token) {
        String username = JwtUtils.getClaimByToken(token).getSubject();
        return Result.ok().data("name", username);
    }

    @PostMapping("/login") //用户登录
    public Result login(String username, String password) {
        USER user = userMapper.selectByUsername(username);

        if (user != null) {
            // 将用户输入的密码进行哈希处理
            String hashedPassword = user.hashPassword(password);

            // 比较用户输入的密码哈希值和数据库中的密码哈希值
            if (hashedPassword.equals(user.getPassword())) {
                String token = JwtUtils.generateToken(user.getUsername());
                return Result.ok().data("token", token);  // 返回令牌给前端
            } else {
                return Result.error().setMessage("密码错误");
            }
        } else {
            return Result.error().setMessage("用户不存在");
        }
    }

    @PostMapping("/regist")
    public Result regist(String username, String password, String code) {
        USER userCheck = userMapper.selectByUsername(username);
        if (userCheck == null) {
            //获取邀请码
            INVITE_CODE inviteCode = inviteCodeMapper.selectByCode(code);
            if(inviteCode != null){
                System.out.println(inviteCode.getIsUsed());

                if(!inviteCode.getIsUsed()){
                    Date time = new Date();
                    USER user = new USER(username, password, time) ;

                    userMapper.insertUser(user);
                    inviteCodeMapper.updateCodeUser(code);

                    return Result.ok().setMessage("新建用户成功");
                } else {
                    return Result.error().setMessage("邀请码已经被使用，注册失败");
                }

            } else {
                return Result.error().setMessage("邀请码不存在，注册失败");
            }

        } else {
            return Result.error().setMessage("用户名已存在，注册失败");
        }


    }

    @PostMapping("/logout")
    public Result logout(String token) {
        return Result.ok();
    }

}
