// 用户类
// @GeneratedValue(strategy = GenerationType.IDENTITY) 对于一些需要自动生成的主键id进行注解

package com.ptp.ptplatform.entity;

import jakarta.persistence.*;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

@Table(name = "user")
public class USER {

    @jakarta.persistence.Id
    private String username;
    private String password;

    @Enumerated(EnumType.STRING)
    private Authority authority;

    private int level; // 用户等级0-6

    @Temporal(TemporalType.DATE)
    private Date registTime = new Date();

    @Temporal(TemporalType.DATE)
    private Date lastLogin;

    private int upload;
    private int download;
    private int shareRate;
    private int magicPoints;

    public enum Authority {
        USER, ADMIN, LIMIT, BAN
    }


    // 函数
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Authority getAuthority() {
        return authority;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Date getRegistTime() {
        return registTime;
    }

    public void setRegistTime(Date registTime) {
        this.registTime = registTime;
    }

    public Date getLastLogin() {
        return lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public int getUpload() {
        return upload;
    }

    public void setUpload(int upload) {
        this.upload = upload;
    }

    public int getDownload() {
        return download;
    }

    public void setDownload(int download) {
        this.download = download;
    }

    public int getShareRate() {
        return shareRate;
    }

    public void setShareRate(int shareRate) {
        this.shareRate = shareRate;
    }

    public int getMagicPoints() {
        return magicPoints;
    }

    public void setMagicPoints(int magicPoints) {
        this.magicPoints = magicPoints;
    }

    public USER() {
    }

    public USER(String username, String password, Date registTime) {
        this.username = username;
        this.registTime = registTime;

        this.password = hashPassword(password);;

        this.authority = Authority.USER;
        this.level = 0;
        this.lastLogin = null;
        this.upload = 0;
        this.download = 0;
        this.shareRate = 100;
        this.magicPoints = 0;
    }

    public String hashPassword(String password) {
        try {
            // 使用SHA-256算法
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(password.getBytes());

            // 将字节数组转换为十六进制字符串
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                hexString.append(String.format("%02x", b));
            }

            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error hashing password", e);
        }
    }
}