package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ptp.ptplatform.entity.USER;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface UserMapper extends BaseMapper<USER> {
    // 查询
    @Select("SELECT * FROM user WHERE username = #{username}")
    USER selectByUsername(String username);

    @Select("SELECT * FROM user WHERE username = #{username} AND password = #{password}")
    USER selectByUsernameAndPassword(String username, String password);

    // 注册用户
    @Insert("INSERT INTO user (username, password, registTime) " +
            "VALUES (#{username}, #{password}, #{registTime})")
    int insertUser(USER user);
}
