package com.ptp.ptplatform.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ptp.ptplatform.entity.HelpPost;
import com.ptp.ptplatform.mapper.HelpPostMapper;
import com.ptp.ptplatform.service.HelpPostService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HelpPostServiceImpl extends ServiceImpl<HelpPostMapper, HelpPost> implements HelpPostService {
    @Override
    @Transactional
    public void incrementLike(int postId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<HelpPost>()
                        .eq("id", postId)
                        .setSql("like_count = like_count + 1")
        );
    }

    @Override
    @Transactional
    public void incrementReplyCount(int postId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<HelpPost>()
                        .eq("id", postId)
                        .setSql("reply_count = reply_count + 1")
        );
    }
}