package com.ptp.ptplatform.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ptp.ptplatform.entity.SeedPost;
import com.ptp.ptplatform.mapper.SeedPostMapper;
import com.ptp.ptplatform.service.SeedPostService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SeedPostServiceImpl extends ServiceImpl<SeedPostMapper, SeedPost> implements SeedPostService {
    @Override
    @Transactional
    public void incrementLike(int postId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<SeedPost>()
                        .eq("id", postId)
                        .setSql("like_count = like_count + 1")
        );
    }

    @Override
    @Transactional
    public void incrementReplyCount(int postId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<SeedPost>()
                        .eq("id", postId)
                        .setSql("reply_count = reply_count + 1")
        );
    }
}