/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common;

import com.accurev.common.data.StreamData;
import com.accurev.common.process.StreamProcess;
import java.util.Hashtable;
import java.util.Vector;

public class CacheManager {
    private Vector depots = null;
    private Hashtable streams = null;
    private Vector workspaces = null;
    private StreamProcess sProcess = new StreamProcess();
    private static CacheManager cacheManager = new CacheManager();

    public static CacheManager getInstance() {
        return cacheManager;
    }

    private CacheManager() {
    }

    public Vector getDepots() {
        if (this.depots == null) {
            this.depots = this.sProcess.runShowDepots();
        }
        return this.depots;
    }

    public void clearDepotCache() {
        this.depots = null;
    }

    public Vector getStreamsByDepot(String depotName) {
        Vector returnStreams = null;
        if (this.streams != null) {
            if (this.streams.containsKey(depotName)) {
                returnStreams = (Vector)this.streams.get(depotName);
                return returnStreams;
            }
        } else {
            this.streams = new Hashtable();
        }
        returnStreams = this.sProcess.runShowAllStreams(depotName);
        this.streams.put(depotName, returnStreams);
        return returnStreams;
    }

    public StreamData getStreamDataByName(String depotName, String streamName) {
        return this.getStreamData(depotName, streamName, "streamName");
    }

    public StreamData getStreamDataByType(String depotName, int streamType) {
        return this.getStreamData(depotName, String.valueOf(streamType), "streamType");
    }

    private StreamData getStreamData(String depotName, String value, String streamProperty) {
        Vector streamsForDepot = this.getStreamsByDepot(depotName);
        StreamData sData = new StreamData();
        for (int i = 0; i < streamsForDepot.size(); ++i) {
            sData = (StreamData)streamsForDepot.get(i);
            if (streamProperty.equals("streamName")) {
                if (!sData.getName().equalsIgnoreCase(value)) continue;
                break;
            }
            int streamType = Integer.parseInt(value);
            if (sData.getType().equalsIgnoreCase(this.sProcess.getStreamType(streamType))) break;
        }
        return sData;
    }

    public void clearStreamCache() {
        this.streams = null;
    }

    public Vector getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = this.sProcess.runShowWorkspaces(false, false);
        }
        return this.workspaces;
    }

    public void clearWorkspaceCache() {
        this.workspaces = null;
    }

    public void clearAllCaches() {
        this.depots = null;
        this.streams = null;
        this.workspaces = null;
    }
}

