/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.data.FieldData;
import com.accurev.common.data.TriggerData;
import com.accurev.common.data.UserData;
import com.accurev.common.data.XMLTag;
import com.accurev.common.process.StreamProcess;
import com.accurev.common.utils.FileUtilities;
import com.accurev.common.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class ClientDispatchPromoteData {
    protected String depotName = "";
    protected UserData userData = null;
    protected boolean enabled = false;
    protected List columnNames = new ArrayList();
    protected boolean queryContainsCurrentDate = false;
    protected String accuWorkIssueQueryPath = null;
    protected static final String fieldKey = "field";
    protected static final String issueNumberKey = "issueNum";
    protected static final String queriesKey = "queries";
    protected static final String queryIssueKey = "queryIssue";
    protected static final String setAsDefaultKey = "setAsDefault";

    public ClientDispatchPromoteData(String depotName, UserData userData) {
        this.depotName = depotName;
        this.userData = userData;
        this.enabled = TriggerData.isClientDispatchTriggerEnabled(depotName);
        if (userData == null) {
            return;
        }
        StreamProcess process = new StreamProcess();
        List tList = process.runGetConfigUserQuery(depotName, userData.getName());
        this.extractDefaultQueryInformation(tList);
    }

    public String getDepotName() {
        return this.depotName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List getColumnNames() {
        return this.columnNames;
    }

    public boolean getQueryContainsCurrentDate() {
        return this.queryContainsCurrentDate;
    }

    public String getAccuWorkIssueQueryPath() {
        return this.accuWorkIssueQueryPath;
    }

    public boolean isQueryValid() {
        return this.accuWorkIssueQueryPath != null;
    }

    protected void extractDefaultQueryInformation(List tagList) {
        if (tagList == null || tagList.size() == 0) {
            return;
        }
        XMLTag queriesTag = (XMLTag)tagList.get(0);
        if (!queriesTag.getName().equalsIgnoreCase(queriesKey)) {
            return;
        }
        List qtList = queriesTag.getTags();
        XMLTag dTag = null;
        for (int findx = 0; findx < qtList.size() && dTag == null; ++findx) {
            XMLTag tag = (XMLTag)qtList.get(findx);
            String defaultValue = tag.getAttributeValue(setAsDefaultKey);
            if (defaultValue == null || !defaultValue.equalsIgnoreCase("true")) continue;
            dTag = tag;
        }
        if (dTag == null) {
            return;
        }
        XMLTag queryIssueTag = dTag.getTag(queryIssueKey);
        if (queryIssueTag == null) {
            return;
        }
        String xmlBuffer = queryIssueTag.toXML();
        this.queryContainsCurrentDate = (xmlBuffer = StringUtilities.replaceAll(xmlBuffer, "CUR_USER", this.userData.getNumber())).indexOf("CUR_DATE") >= 0;
        this.accuWorkIssueQueryPath = FileUtilities.createTemporaryFile(xmlBuffer);
        List ftList = dTag.getTags(fieldKey);
        if (ftList.size() > 0) {
            this.columnNames.addAll(FieldData.getColumnInformation(ftList, this.depotName));
        }
        this.checkForQueryColumns();
    }

    protected void checkForQueryColumns() {
        if (this.isEnabled() && this.columnNames.size() == 0) {
            FieldData fData = new FieldData();
            fData.setFieldName(issueNumberKey);
            fData.setColumnName(issueNumberKey);
            this.columnNames.add(fData);
            FieldData.getColumnLabels(this.columnNames, this.depotName);
        }
    }
}

