/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.data.ChangePackageData;
import com.accurev.common.data.ClientDispatchPromoteData;
import com.accurev.common.data.XMLTag;
import com.accurev.common.process.StreamProcess;
import com.accurev.common.utils.FileUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class IssueData {
    protected String issueNumber;
    protected Hashtable fields = new Hashtable();
    private static final String issueKey = "issue";
    private static final String issuesKey = "issues";
    private static final String issueNumberKey = "issueNum";

    public IssueData(String issueNumber) {
        this.issueNumber = issueNumber;
        this.fields.put(issueNumberKey, issueNumber);
    }

    public String getIssueNumber() {
        return this.issueNumber;
    }

    public String getFieldValue(String name) {
        return name == null ? null : (String)this.fields.get(name);
    }

    public void setField(String name, String value) {
        if (name != null && value != null) {
            this.fields.put(name, value);
        }
    }

    public Hashtable getFields() {
        return this.fields;
    }

    public static List getIssueData(ChangePackageData cpData, ClientDispatchPromoteData cdpData) {
        if (!cpData.isEnabled() && !cdpData.isEnabled()) {
            return new ArrayList();
        }
        String queryPath = cpData.getAccuWorkIssueQueryPath();
        boolean replaceDate = cpData.getQueryContainsCurrentDate();
        if (!cpData.isEnabled()) {
            queryPath = cdpData.getAccuWorkIssueQueryPath();
            replaceDate = cdpData.getQueryContainsCurrentDate();
        }
        if (queryPath == null) {
            return new ArrayList();
        }
        if (replaceDate) {
            queryPath = FileUtilities.replaceCurrentDate(queryPath);
        }
        StreamProcess process = new StreamProcess();
        List tagList = process.runXML(queryPath);
        if (replaceDate && queryPath != null) {
            File lFile = new File(queryPath);
            lFile.delete();
        }
        return IssueData.extractIssueData(tagList);
    }

    protected static List extractIssueData(List tagList) {
        ArrayList<IssueData> issuesList = new ArrayList<IssueData>();
        if (tagList.size() < 0) {
            return issuesList;
        }
        XMLTag issuesTag = (XMLTag)tagList.get(0);
        if (!issuesTag.getName().equalsIgnoreCase(issuesKey)) {
            return issuesList;
        }
        List itList = issuesTag.getTags();
        for (int findx = 0; findx < itList.size(); ++findx) {
            XMLTag issueNumber;
            XMLTag issueTag = (XMLTag)itList.get(findx);
            if (!issueTag.getName().equalsIgnoreCase(issueKey) || (issueNumber = issueTag.getTag(issueNumberKey)) == null) continue;
            IssueData issueData = new IssueData(issueNumber.getContent());
            issuesList.add(issueData);
            List ltList = issueTag.getTags();
            for (int tIndex = 0; tIndex < ltList.size(); ++tIndex) {
                XMLTag lTag = (XMLTag)ltList.get(tIndex);
                String content = lTag.getContent();
                if (content.length() <= 0) continue;
                issueData.setField(lTag.getName(), content);
            }
        }
        return issuesList;
    }
}

