/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.data;

import com.accurev.common.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class XMLTag {
    protected String name;
    protected XMLTag parent;
    protected StringBuffer content = new StringBuffer();
    protected Hashtable attributes = new Hashtable();
    protected List tags = new ArrayList();

    public XMLTag(String name, XMLTag parent) {
        this.name = name;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public XMLTag getParent() {
        return this.parent;
    }

    public String getContent() {
        return this.content.toString().trim();
    }

    public void appendToContent(String data) {
        this.content.append(data);
    }

    public void appendToContent(char[] data, int offset, int length) {
        this.content.append(data, offset, length);
    }

    public String getAttributeValue(String name) {
        return name == null ? null : (String)this.attributes.get(name);
    }

    public void addAttribute(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.attributes.put(name, value);
    }

    public List getTags() {
        return new ArrayList(this.tags);
    }

    public List getTags(String tagName) {
        ArrayList<XMLTag> tList = new ArrayList<XMLTag>();
        if (tagName == null) {
            return tList;
        }
        for (int findx = 0; findx < this.tags.size(); ++findx) {
            XMLTag lTag = (XMLTag)this.tags.get(findx);
            if (!tagName.equals(lTag.name)) continue;
            tList.add(lTag);
        }
        return tList;
    }

    public XMLTag getTag(String tagName) {
        XMLTag xmlTag = null;
        if (tagName == null) {
            return xmlTag;
        }
        for (int findx = 0; findx < this.tags.size(); ++findx) {
            XMLTag lTag = (XMLTag)this.tags.get(findx);
            if (!tagName.equals(lTag.name)) continue;
            xmlTag = lTag;
            break;
        }
        return xmlTag;
    }

    public void addTag(XMLTag tag) {
        if (tag == null) {
            return;
        }
        this.tags.add(tag);
    }

    public String toXML() {
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer.append("<");
        xmlBuffer.append(this.name);
        Enumeration kenum = this.attributes.keys();
        while (kenum.hasMoreElements()) {
            String key = (String)kenum.nextElement();
            String value = (String)this.attributes.get(key);
            xmlBuffer.append(" ");
            xmlBuffer.append(key);
            xmlBuffer.append("=");
            xmlBuffer.append("\"");
            xmlBuffer.append(value);
            xmlBuffer.append("\"");
        }
        xmlBuffer.append(">");
        xmlBuffer.append("\n");
        for (int findx = 0; findx < this.tags.size(); ++findx) {
            XMLTag lTag = (XMLTag)this.tags.get(findx);
            xmlBuffer.append(lTag.toXML());
        }
        String contentXML = this.contentToXML();
        if (contentXML.length() != 0) {
            xmlBuffer.append(contentXML);
            xmlBuffer.append("\n");
        }
        xmlBuffer.append("</");
        xmlBuffer.append(this.name);
        xmlBuffer.append(">");
        xmlBuffer.append("\n");
        return xmlBuffer.toString();
    }

    public String contentToXML() {
        String lContent = StringUtilities.toStandardString(this.getContent());
        return StringUtilities.toXMLString(lContent);
    }
}

