/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AccuRevHandler
extends DefaultHandler {
    protected StringBuffer messageData;
    protected boolean isMessageTagProcessingInProgress = false;
    protected boolean hasBeenInterrupted = false;
    protected static final String PARSER_INTERRUPTED = "Parse Interrupted";
    protected static final String MESSAGE_NAME = "message";

    protected AccuRevHandler() {
    }

    public void startDocument() throws SAXException {
        this.messageData = new StringBuffer();
        this.isMessageTagProcessingInProgress = false;
        if (this.hasBeenInterrupted) {
            throw new SAXException(PARSER_INTERRUPTED);
        }
    }

    public void endDocument() throws SAXException {
        if (this.hasBeenInterrupted) {
            throw new SAXException(PARSER_INTERRUPTED);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        if (this.hasBeenInterrupted) {
            throw new SAXException(PARSER_INTERRUPTED);
        }
        if (name.equalsIgnoreCase(MESSAGE_NAME)) {
            this.isMessageTagProcessingInProgress = true;
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.hasBeenInterrupted) {
            throw new SAXException(PARSER_INTERRUPTED);
        }
        if (name.equalsIgnoreCase(MESSAGE_NAME)) {
            this.isMessageTagProcessingInProgress = false;
        }
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        if (this.hasBeenInterrupted) {
            throw new SAXException(PARSER_INTERRUPTED);
        }
        if (this.isMessageTagProcessingInProgress) {
            this.messageData.append(charArray, start, length);
        }
    }

    public void ignorableWhitespace(char[] charArray, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void interrupt() {
        this.hasBeenInterrupted = true;
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.err.println("Warning - Line: " + exception.getLineNumber() + ", Column: " + exception.getColumnNumber() + "\n  " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXException {
        System.err.println("Error - Line: " + exception.getLineNumber() + ", Column: " + exception.getColumnNumber() + "\n  " + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println("Fatal Error - Line: " + exception.getLineNumber() + ", Column: " + exception.getColumnNumber() + "\n  " + exception.getMessage());
        throw exception;
    }

    public String getMessageData() {
        if (this.messageData == null || this.messageData.length() == 0) {
            return null;
        }
        return this.messageData.toString();
    }
}

