/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.data.AnnotateData;
import com.accurev.common.data.TransactionData;
import com.accurev.common.parsers.AccuRevHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AnnotateParser
extends AccuRevHandler {
    private Map transactionTable = new HashMap();
    private List finalAnnotates = new ArrayList();
    private TransactionData transactionData;
    private AnnotateData annotateData;
    private String value;

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, name, attrs);
        if (attrs != null) {
            if (name.equals("trans")) {
                this.transactionData = new TransactionData();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    if (attrs.getQName(i).equalsIgnoreCase("number")) {
                        this.transactionData.setTranId(attrs.getValue(i));
                        continue;
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("principal_name")) {
                        this.transactionData.setTranUser(attrs.getValue(i));
                        continue;
                    }
                    if (!attrs.getQName(i).equalsIgnoreCase("time")) continue;
                    this.transactionData.setTranTime(attrs.getValue(i));
                }
            } else if (name.equals("final")) {
                this.finalAnnotates = new ArrayList();
            } else if (name.equals("line")) {
                this.annotateData = new AnnotateData();
                this.annotateData.setLineNumber(Long.parseLong(attrs.getValue("number")));
                this.annotateData.setTranNumber(attrs.getValue("trans"));
                this.value = "";
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (name.equals("diff")) {
            if (this.transactionData.getTranId().equals("0") && this.finalAnnotates.isEmpty()) {
                return;
            }
            this.transactionTable.put(this.transactionData.getTranId(), this.transactionData);
        } else if (name.equals("final")) {
            for (int i = 0; i < this.finalAnnotates.size(); ++i) {
                this.annotateData = (AnnotateData)this.finalAnnotates.get(i);
                this.transactionData = (TransactionData)this.transactionTable.get(this.annotateData.getTranNumber());
                if (this.transactionData == null) continue;
                this.annotateData.setTranTime(this.transactionData.getTranTime());
                this.annotateData.setTranUserName(this.transactionData.getTranUser());
            }
        } else if (name.equals("line")) {
            this.annotateData.setContent(this.value);
            this.finalAnnotates.add(this.annotateData);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.value = this.value + new String(ch, start, length);
    }

    public List getFinalAnnotates() {
        return this.finalAnnotates;
    }
}

