/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.data.XMLTag;
import com.accurev.common.parsers.AccuRevHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GenericXMLParser
extends AccuRevHandler {
    protected XMLTag currentTag = null;
    protected List tagList = new ArrayList();

    public List getTagList() {
        return this.tagList;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.hasBeenInterrupted) {
            throw new SAXException("Parse Interrupted");
        }
        XMLTag lTag = new XMLTag(name, this.currentTag);
        if (this.currentTag == null) {
            this.tagList.add(lTag);
        } else {
            this.currentTag.addTag(lTag);
        }
        for (int findx = 0; findx < attributes.getLength(); ++findx) {
            lTag.addAttribute(attributes.getQName(findx), attributes.getValue(findx));
        }
        this.currentTag = lTag;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.hasBeenInterrupted) {
            throw new SAXException("Parse Interrupted");
        }
        if (this.currentTag != null) {
            this.currentTag = this.currentTag.getParent();
        }
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        super.characters(charArray, start, length);
        if (this.hasBeenInterrupted) {
            throw new SAXException("Parse Interrupted");
        }
        if (this.currentTag != null) {
            this.currentTag.appendToContent(charArray, start, length);
        }
    }
}

