/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.parsers;

import com.accurev.common.Constants;
import com.accurev.common.parsers.AccuRevHandler;
import com.accurev.common.process.thread.ProcessStatusListener;
import com.accurev.common.utils.StringUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LogParser
extends AccuRevHandler {
    private File logFile = null;
    private ByteArrayOutputStream logBuffer = null;
    private PrintStream out = null;
    private String messageString = "";
    private boolean isErrorMessage;
    private StringBuffer errorMessageText = new StringBuffer();
    private String phaseName = "";
    private String progressText = "";
    private int elemCount = 0;
    private int elemIncrement = 0;
    private int elemProcessed = 0;
    private boolean elementTagFound = false;
    private ProcessStatusListener progressListener = null;
    private boolean logToFile = false;
    private String operationName = "";

    public LogParser(String operationName, ProcessStatusListener listener, boolean logToFile) {
        this.operationName = operationName;
        this.progressListener = listener;
        this.logToFile = logToFile;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        try {
            if (this.logToFile) {
                this.logFile = File.createTempFile("log", null);
                this.logFile.deleteOnExit();
                this.out = new PrintStream(new FileOutputStream(this.logFile));
            } else {
                this.logBuffer = new ByteArrayOutputStream();
                this.out = new PrintStream(this.logBuffer);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.println(this.operationName + " started");
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.errorMessageText.length() > 0) {
            this.out.println("*** " + this.operationName + " failed. See message above. ***");
        } else {
            this.out.println(this.operationName + " complete.");
        }
        this.out.flush();
        this.out.close();
        if (this.errorMessageText.length() > 0 && this.progressListener != null) {
            this.progressListener.notifyErrorMessage(this.errorMessageText.toString());
        }
        if (this.progressListener != null) {
            this.progressListener.notifyParsingComplete(this.errorMessageText.toString(), this.logFile);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        super.startElement(uri, localName, name, attrs);
        if (attrs != null) {
            if (name.equalsIgnoreCase("acResponse")) {
                if (this.progressListener != null) {
                    String taskID = attrs.getValue("TaskId");
                    this.progressListener.notifyProcessId(taskID);
                }
            } else if (name.equalsIgnoreCase("progress")) {
                this.phaseName = attrs.getValue("phase");
                this.progressText = "";
                String elemCountString = attrs.getValue("number");
                this.elemCount = elemCountString == null ? 0 : Integer.parseInt(elemCountString);
                String elemIncrementString = attrs.getValue("increment");
                this.elemIncrement = elemIncrementString == null ? 1 : Integer.parseInt(elemIncrementString);
                this.elemProcessed = 0;
                if (this.progressListener != null) {
                    this.progressListener.notifyPhaseChange(this.phaseName);
                    this.progressListener.notifyProcessMaxSize(this.elemCount);
                }
                if (this.phaseName.equals("results")) {
                    this.out.println("Making " + elemCountString + " changes");
                } else {
                    this.out.print(this.phaseName);
                }
            } else if (name.equalsIgnoreCase("checkpoint")) {
                this.elemProcessed += this.elemIncrement;
                if (this.progressListener != null) {
                    this.progressListener.notifyProgressUpdate(this.elemProcessed);
                }
                this.messageString = "";
            } else if (name.equalsIgnoreCase("element")) {
                this.elementTagFound = true;
                this.progressText = attrs.getValue("location");
                if (this.progressListener != null) {
                    this.progressListener.notifyElementProcessed(this.progressText);
                }
            } else if (name.equalsIgnoreCase("message")) {
                this.messageString = "";
                this.isErrorMessage = attrs.getValue("error") == null ? false : attrs.getValue("error").equalsIgnoreCase("true");
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (name.equalsIgnoreCase("progress") && !this.phaseName.equals("results")) {
            this.out.println(" - ok");
        } else if (name.equalsIgnoreCase("message")) {
            this.messageString = this.messageString.trim();
            if (this.messageString.equals("")) {
                return;
            }
            this.messageString = StringUtilities.replaceAll(this.messageString, "\n", Constants.LINE_SEPARATOR);
            this.out.println(this.messageString);
            if (this.isErrorMessage) {
                this.errorMessageText.append(this.messageString + "\n");
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.messageString = this.messageString + new String(ch, start, length);
    }

    public File getLogFile() {
        return this.logFile;
    }

    public String getLogBuffer() {
        if (this.logBuffer != null) {
            return this.logBuffer.toString();
        }
        return "";
    }

    public boolean isElementTagFound() {
        return this.elementTagFound;
    }
}

