/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.parsers.CPKFieldParser;
import com.accurev.common.parsers.IssueCPKParser;
import com.accurev.common.parsers.IssueParser;
import com.accurev.common.parsers.SchemaParser;
import com.accurev.common.process.RunProcess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;

public class AccuWorkProcess
extends RunProcess {
    public Map getSchemaFields(String depotName) {
        String[] commands = new String[]{accurevExecutable, "getConfig", "-p", depotName, "-r", "schema.xml"};
        SchemaParser schemaParser = new SchemaParser();
        this.exec(commands, null, schemaParser);
        return schemaParser.getSchemaFields();
    }

    public List getChangePackageFields(String depotName) {
        String[] commands = new String[]{accurevExecutable, "getconfig", "-p", depotName, "-r", "cpk_fields.xml"};
        CPKFieldParser parser = new CPKFieldParser();
        this.exec(commands, null, parser);
        return parser.getFields();
    }

    public List getStreamIssues(String depotName, String userName, String streamName, boolean showActive, boolean showMissing, boolean recursive) {
        File queryFile = null;
        PrintStream out = null;
        try {
            queryFile = File.createTempFile("query", null);
            queryFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(queryFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("<acRequest> <issuelist " + (showActive ? "show_active = \"true\"" : "") + (recursive ? " recursive = \"true\"" : "") + (showMissing ? "show_missing = \"true\"" : "") + ">");
        out.println("<user>" + userName + "</user>");
        out.println("<depot>" + depotName + "</depot>");
        out.println("<stream1>" + streamName + "</stream1>");
        out.println("<issues>");
        out.println("</issues>");
        out.println("</issuelist> </acRequest>");
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", queryFile.getAbsolutePath()};
        IssueParser issueParser = new IssueParser();
        this.exec(cmds, null, issueParser);
        queryFile.delete();
        return issueParser.getIssues();
    }

    public List getStreamDiffIssues(String depotName, String userName, String srcStreamName, String destStreamName) {
        File queryFile = null;
        PrintStream out = null;
        try {
            queryFile = File.createTempFile("query", null);
            queryFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(queryFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("<acRequest> <issuediff>");
        out.println("<user>" + userName + "</user>");
        out.println("<depot>" + depotName + "</depot>");
        out.println("<stream1>" + srcStreamName + "</stream1>");
        out.println("<stream2>" + destStreamName + "</stream2>");
        out.println("<issues>");
        out.println("</issues>");
        out.println("</issuediff> </acRequest>");
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", queryFile.getAbsolutePath()};
        IssueParser issueParser = new IssueParser();
        this.exec(cmds, null, issueParser);
        queryFile.delete();
        return issueParser.getIssues();
    }

    public Map getIssuesDetails(String depotName, String userName, List issues) {
        File queryFile = null;
        PrintStream out = null;
        try {
            queryFile = File.createTempFile("query", null);
            queryFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(queryFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("<acRequest> <issuelist>");
        out.println("<user>" + userName + "</user>");
        out.println("<depot>" + depotName + "</depot>");
        out.println("<issues>");
        for (int i = 0; i < issues.size(); ++i) {
            out.println("<issueNum>" + issues.get(i) + "</issueNum>");
        }
        out.println("</issues>");
        out.println("</issuelist> </acRequest>");
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", queryFile.getAbsolutePath()};
        IssueParser issueParser = new IssueParser();
        this.exec(cmds, null, issueParser);
        queryFile.delete();
        return issueParser.getIssuesMap();
    }

    public List getIssueChangePackage(String depotName, String userName, String streamName, String issueNum, String transNum) {
        File queryFile = null;
        PrintStream out = null;
        try {
            queryFile = File.createTempFile("issuecpk", null);
            queryFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(queryFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println("<acRequest> <cpkdescribe>");
        out.println("<user>" + userName + "</user>");
        out.println("<depot>" + depotName + "</depot>");
        if (streamName != null) {
            out.println("<stream1>" + streamName + "</stream1>");
        }
        if (transNum != null) {
            out.println("<transaction>" + transNum + "</transaction>");
        }
        out.println("<issues>");
        out.println("<issueNum>" + issueNum + "</issueNum>");
        out.println("</issues>");
        out.println("</cpkdescribe> </acRequest>");
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", queryFile.getAbsolutePath()};
        IssueCPKParser issueCPKParser = new IssueCPKParser();
        this.exec(cmds, null, issueCPKParser);
        queryFile.delete();
        return issueCPKParser.getIssueCPK();
    }

    public int putConfig(String depotName, String xmlFileName, String filePath) {
        return this.putConfig(depotName, null, xmlFileName, filePath);
    }

    public int putConfig(String depotName, String userName, String xmlFileName, String filePath) {
        if (userName == null) {
            String[] cmds = new String[]{accurevExecutable, "putconfig", "-p", depotName, "-r", xmlFileName, "-l", filePath};
            return this.exec(cmds, null);
        }
        String[] cmds = new String[]{accurevExecutable, "putconfig", "-u", userName, "-p", depotName, "-r", xmlFileName, "-l", filePath};
        return this.exec(cmds, null);
    }

    public int runXML(String xmlString) {
        File xmlFile = null;
        PrintStream out = null;
        try {
            xmlFile = File.createTempFile("xml", null);
            xmlFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println(xmlString);
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", xmlFile.getAbsolutePath()};
        IssueParser issueParser = new IssueParser();
        int retValue = this.exec(cmds, null, issueParser);
        xmlFile.delete();
        return retValue;
    }
}

