/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.MessageHandler;
import com.accurev.common.data.NameData;
import com.accurev.common.parsers.NameParser;
import com.accurev.common.process.RunProcess;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class CatProcess
extends RunProcess {
    public String catFile(String streamNameVersion, String elementId, String elementName) {
        return this.catFile(streamNameVersion, elementId, elementName, false);
    }

    public String catFile(String streamNameVersion, String elementId, String elementName, boolean isSilent) {
        File localFile = null;
        try {
            localFile = File.createTempFile("cat", elementName);
            localFile.deleteOnExit();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] commandArray = new String[]{accurevExecutable, "cat", "-v", streamNameVersion, "-e", elementId};
        int commandStatus = this.execNoWait(commandArray, null);
        if (commandStatus == 0) {
            commandStatus = this.processCatOutput(localFile, isSilent);
        }
        if (commandStatus != 0) {
            localFile.delete();
            localFile = null;
        }
        return localFile == null ? null : localFile.getAbsolutePath();
    }

    public String catFileByPath(String streamNameVersion, String elementPath, String elementName, String depotName, boolean isSilent) {
        return this.catFile(streamNameVersion, null, elementPath, elementName, depotName, true);
    }

    public String catFile(String streamNameVersion, String elementId, String elementName, String depotName, boolean isSilent) {
        return this.catFile(streamNameVersion, elementId, null, elementName, depotName, true);
    }

    public String catFile(String streamNameVersion, String elementId, String elementPath, String elementName, String depotName, boolean isSilent) {
        File localFile = null;
        try {
            localFile = File.createTempFile("cat", elementName);
            localFile.deleteOnExit();
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<String> cmdVector = new Vector<String>();
        cmdVector.add(accurevExecutable);
        cmdVector.add("cat");
        cmdVector.add("-v");
        cmdVector.add(streamNameVersion);
        cmdVector.add("-p");
        cmdVector.add(depotName);
        if (elementId != null && !elementId.equals("")) {
            cmdVector.add("-e");
            cmdVector.add(elementId);
        } else {
            cmdVector.add(elementPath);
        }
        String[] commandArray = cmdVector.toArray(new String[0]);
        int commandStatus = this.execNoWait(commandArray, null);
        if (commandStatus == 0) {
            commandStatus = this.processCatOutput(localFile, isSilent);
        }
        if (commandStatus != 0) {
            localFile.delete();
            localFile = null;
        }
        return localFile == null ? null : localFile.getAbsolutePath();
    }

    public String catFileInDirectory(String fileName, String fileDirectory, String versionNumber) {
        File localFile = null;
        try {
            localFile = File.createTempFile("cat", fileName);
            localFile.deleteOnExit();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] commandArray = new String[]{RunProcess.accurevExecutable, "cat", "-v", versionNumber, fileName};
        int commandStatus = this.execNoWait(commandArray, fileDirectory);
        if (commandStatus == 0) {
            commandStatus = this.processCatOutput(localFile, false);
        }
        if (commandStatus != 0) {
            localFile.delete();
            localFile = null;
        }
        return localFile == null ? null : localFile.getAbsolutePath();
    }

    protected int processCatOutput(File localFile, boolean isSilent) {
        int commandStatus;
        try {
            int bytesRead;
            StringBuffer errorString = new StringBuffer();
            RunProcess.InputStreamReaderThread errorThread = new RunProcess.InputStreamReaderThread(this.error, errorString);
            errorThread.start();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));
            byte[] buffer = new byte[1024];
            while ((bytesRead = this.input.read(buffer)) > 0) {
                out.write(buffer, 0, bytesRead);
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            errorThread.join();
            this.runProcess.waitFor();
            commandStatus = this.runProcess.exitValue();
            if (commandStatus != 0) {
                String errorMessageText = errorString.toString();
                if (!isSilent && errorMessageText.length() > 0) {
                    MessageHandler.showErrorMessage(errorMessageText);
                }
            }
        }
        catch (IOException e) {
            commandStatus = -100003;
        }
        catch (InterruptedException e) {
            commandStatus = -100002;
        }
        return commandStatus;
    }

    public String getFileName(String depotName, String streamNumVersion, String fileEID) {
        String fileName = "";
        String[] cmds = new String[]{accurevExecutable, "name", "-e", fileEID, "-p", depotName, "-v", streamNumVersion};
        if (this.exec(cmds, null, false) != 0) {
            return null;
        }
        fileName = this.getResponseText().toString();
        fileName = fileName.replace('/', File.separatorChar);
        return fileName.trim();
    }

    public String getFileName(String streamNameVersion, String fileEID) {
        String fileName = "";
        String[] cmds = new String[]{accurevExecutable, "name", "-e", fileEID, "-v", streamNameVersion};
        if (this.exec(cmds, null, false) != 0) {
            return null;
        }
        fileName = this.getResponseText().toString();
        fileName = fileName.replace('/', File.separatorChar);
        return fileName.trim();
    }

    public NameData getFileNameData(String depotName, String streamNumVersion, String fileEID) {
        String[] cmds = new String[]{accurevExecutable, "name", "-fx", "-e", fileEID, "-p", depotName, "-v", streamNumVersion};
        NameParser nameParser = new NameParser();
        int commandStatus = this.exec(cmds, null, nameParser);
        if (commandStatus == 0) {
            return nameParser.getNameData();
        }
        return null;
    }

    public byte[] getFileContentByFilePath(String version, String elementPath, String depotName) {
        String[] commandArray = new String[]{accurevExecutable, "cat", "-v", version, "-p", depotName, elementPath};
        return this.getContent(commandArray);
    }

    public byte[] getFileContent(String streamNameVersion, String elementId, String depotName) {
        String[] commandArray = new String[]{accurevExecutable, "cat", "-v", streamNameVersion, "-p", depotName, "-e", elementId};
        return this.getContent(commandArray);
    }

    private byte[] getContent(String[] commandArray) {
        int commandStatus = this.execNoWait(commandArray, null);
        byte[] content = new byte[]{};
        if (commandStatus == 0) {
            try {
                int bytesRead;
                StringBuffer errorString = new StringBuffer();
                RunProcess.InputStreamReaderThread errorThread = new RunProcess.InputStreamReaderThread(this.error, errorString);
                errorThread.start();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                BufferedOutputStream out = new BufferedOutputStream(output);
                byte[] buffer = new byte[1024];
                while ((bytesRead = this.input.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesRead);
                }
                if (out != null) {
                    out.flush();
                    out.close();
                    content = output.toByteArray();
                }
                errorThread.join();
                this.runProcess.waitFor();
                commandStatus = this.runProcess.exitValue();
            }
            catch (IOException e) {
                commandStatus = -100003;
            }
            catch (InterruptedException e) {
                commandStatus = -100002;
            }
        }
        return content;
    }
}

