/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.Constants;
import com.accurev.common.MessageHandler;
import com.accurev.common.data.AcResponseData;
import com.accurev.common.parsers.AcResponseParser;
import com.accurev.common.parsers.AnnotateParser;
import com.accurev.common.parsers.HistoryParser;
import com.accurev.common.parsers.StatusParser;
import com.accurev.common.parsers.StreamDirStructParser;
import com.accurev.common.process.RunProcess;
import com.accurev.common.process.thread.ProcessStatusListener;
import com.accurev.common.utils.SecurityUtils;
import com.accurev.common.utils.StringUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class ElementProcess
extends RunProcess {
    private boolean allFilesHaveCPKGap = false;
    private boolean cpkMergeRequired = false;
    private String filesWithCPKGap = "";
    static /* synthetic */ Class class$com$accurev$common$data$AcResponseData;

    public int addToDepot(String workingDirectory, String elementListPath, String commentPath, ProcessStatusListener listener) {
        String[] commandArray = new String[]{accurevExecutable, "add", "-Z", new String("-c@" + commentPath), "-l", elementListPath};
        return this.execWithTaskProgressBar(commandArray, "Add to Depot", workingDirectory, listener);
    }

    public int anchorElements(String workingDirectory, String elementListPath) {
        String[] commandArray = new String[]{accurevExecutable, "anchor", "-O", "-l", elementListPath};
        return this.exec(commandArray, workingDirectory);
    }

    public int annotateFile(String version, String filePath, Collection finalAnnotates) {
        String[] cmds = new String[]{accurevExecutable, "annotate", "-fx", "-v", version, filePath};
        AnnotateParser annotateParser = new AnnotateParser();
        int commandStatus = this.exec(cmds, null, annotateParser);
        if (finalAnnotates != null) {
            finalAnnotates.clear();
            finalAnnotates.addAll(annotateParser.getFinalAnnotates());
        }
        return commandStatus;
    }

    public int checkoutElement(String workingDirectory, String streamNumberAndVersion, String elementPath) {
        String[] commandArray = new String[]{accurevExecutable, "co", "-v", streamNumberAndVersion, elementPath};
        return this.exec(commandArray, workingDirectory);
    }

    public int defunctElements(String workingDirectory, String elementListPath, String commentPath) {
        String[] commandArray = new String[]{accurevExecutable, "defunct", "-l", elementListPath, new String("-c@" + commentPath)};
        return this.exec(commandArray, workingDirectory);
    }

    public int statusElementsInDirectory(String workingDirectory, String directoryPath, Class containerClass, Collection statusData) {
        String[] commandArray = new String[]{accurevExecutable, "files", "-fx", directoryPath};
        StatusParser statusParser = new StatusParser(containerClass);
        int commandStatus = this.exec(commandArray, workingDirectory, statusParser);
        if (statusData != null) {
            statusData.clear();
            statusData.addAll(statusParser.getElementStatusCollection());
        }
        return commandStatus;
    }

    public int statusElements(String workingDirectory, String elementListPath, Class containerClass, Collection statusData) {
        return this.statusElements(workingDirectory, elementListPath, containerClass, statusData, null);
    }

    public int statusElements(String workingDirectory, String elementListPath, Class containerClass, Collection statusData, ProcessStatusListener listener) {
        String[] commandArray = new String[]{accurevExecutable, "stat", "-fex", "-l", elementListPath};
        StatusParser statusParser = new StatusParser(containerClass, listener);
        int commandStatus = this.execWithAsyncParsing(commandArray, workingDirectory, statusParser);
        if (statusData != null) {
            statusData.clear();
            statusData.addAll(statusParser.getElementStatusCollection());
        }
        return commandStatus;
    }

    public int statusElements(String workingDirectory, int searchType, Class containerClass, Collection statusData) {
        String[] searchOptions = this.getSearchStatusOption(searchType);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(accurevExecutable);
        commandList.add("stat");
        commandList.add("-fex");
        for (int i = 0; i < searchOptions.length; ++i) {
            commandList.add(searchOptions[i]);
        }
        if (searchType == 12 || searchType == 11) {
            commandList.add(workingDirectory);
        }
        int size = commandList.size();
        String[] commandArray = new String[size];
        int i = 0;
        Iterator iter = commandList.iterator();
        while (iter.hasNext()) {
            String element;
            commandArray[i] = element = (String)iter.next();
            ++i;
        }
        StatusParser statusParser = new StatusParser(containerClass);
        int commandStatus = this.exec(commandArray, workingDirectory, statusParser);
        if (statusData != null) {
            statusData.clear();
            statusData.addAll(statusParser.getElementStatusCollection());
        }
        return commandStatus;
    }

    public int elementHistory(String workingDirectory, String elementPath, Collection historyData) {
        String[] commandArray = new String[]{accurevExecutable, "hist", "-fx", elementPath};
        HistoryParser historyParser = new HistoryParser();
        int commandStatus = this.exec(commandArray, workingDirectory, historyParser);
        if (historyData != null) {
            historyData.clear();
            historyParser.convertVersionData();
            historyData.addAll(historyParser.getHistoryDataCollection());
        }
        return commandStatus;
    }

    public int histTransaction(String workingDirectory, String depotName, String userName, String tranNum, boolean showVersions, Collection transData) {
        Vector<String> cmdVector = new Vector<String>();
        cmdVector.add(accurevExecutable);
        cmdVector.add("hist");
        cmdVector.add(showVersions ? "-fx" : "-fxt");
        if (!"".equals(userName)) {
            cmdVector.add("-u");
            cmdVector.add(userName);
        }
        cmdVector.add("-t");
        cmdVector.add(tranNum);
        cmdVector.add("-p");
        cmdVector.add(depotName);
        String[] commandArray = cmdVector.toArray(new String[0]);
        HistoryParser historyParser = new HistoryParser();
        int commandStatus = this.exec(commandArray, workingDirectory, historyParser);
        if (transData != null) {
            transData.clear();
            transData.addAll(historyParser.getHistoryDataCollection());
        }
        return commandStatus;
    }

    public int parseHistFile(String workingDirectory, String depotName, String filePath, String fileEID, String userName, String from, String to, String step, String commentFilter, boolean showVersions, Collection transData) {
        Vector<String> cmdVector = new Vector<String>();
        cmdVector.add(accurevExecutable);
        cmdVector.add("hist");
        cmdVector.add(showVersions ? "-fx" : "-fxt");
        if (!"".equals(commentFilter)) {
            cmdVector.add("-c");
            cmdVector.add(commentFilter);
        }
        if (!"".equals(userName)) {
            cmdVector.add("-u");
            cmdVector.add(userName);
        }
        cmdVector.add("-t" + from + "-" + to + (step.equals("") ? "" : "." + step));
        cmdVector.add("-p");
        cmdVector.add(depotName);
        cmdVector.add("-e");
        cmdVector.add(fileEID);
        String[] commandArray = cmdVector.toArray(new String[0]);
        HistoryParser historyParser = new HistoryParser();
        int commandStatus = this.exec(commandArray, null, historyParser);
        if (transData != null) {
            transData.clear();
            transData.addAll(historyParser.getHistoryDataCollection());
        }
        return commandStatus;
    }

    public int keepElements(String workingDirectory, String elementListPath, String commentPath) {
        String[] commandArray = new String[]{accurevExecutable, "keep", "-c@" + commentPath, "-l", elementListPath};
        return this.exec(commandArray, workingDirectory);
    }

    public int populateElements(String workingDirectory, String elementListPath, boolean recursiveOption, boolean overwriteOption) {
        Vector<String> commandCollection = new Vector<String>();
        commandCollection.add(accurevExecutable);
        commandCollection.add("pop");
        if (recursiveOption) {
            commandCollection.add("-R");
        }
        if (overwriteOption) {
            commandCollection.add("-O");
        }
        commandCollection.add("-l");
        commandCollection.add(elementListPath);
        String[] commandArray = new String[commandCollection.size()];
        commandCollection.toArray(commandArray);
        return this.exec(commandArray, workingDirectory);
    }

    public int promoteElements(String workingDirectory, String elementListPath, String commentPath, String issueNumber) {
        Vector<String> commandCollection = new Vector<String>();
        commandCollection.add(accurevExecutable);
        commandCollection.add("promote");
        String issues = "";
        if (issueNumber != null && issueNumber.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(issueNumber);
            while (tokenizer.hasMoreElements()) {
                String issue = tokenizer.nextToken();
                int issueNum = Integer.parseInt(issue);
                if (issueNum < 0) {
                    issueNum *= -1;
                }
                issues = issues + issueNum + " ";
            }
            commandCollection.add("-I");
            commandCollection.add(issues);
        }
        commandCollection.add(new String("-c@" + commentPath));
        commandCollection.add("-l");
        commandCollection.add(elementListPath);
        String[] commandArray = new String[commandCollection.size()];
        commandCollection.toArray(commandArray);
        String cmd = "";
        for (int i = 0; i < commandArray.length; ++i) {
            cmd = cmd + commandArray[i] + " ";
        }
        int commandStatus = 0;
        try {
            int bytesRead;
            commandStatus = this.execNoWait(commandArray, workingDirectory);
            cmd = "";
            for (int i = 0; i < commandArray.length; ++i) {
                cmd = cmd + commandArray[i] + " ";
            }
            StringBuffer errorString = new StringBuffer();
            RunProcess.InputStreamReaderThread errorThread = new RunProcess.InputStreamReaderThread(this.error, errorString);
            errorThread.start();
            PrintStream outputStream = new PrintStream(this.output);
            byte[] buffer = new byte[1024];
            StringBuffer inputBuffer = new StringBuffer();
            while ((bytesRead = this.input.read(buffer)) > 0) {
                String inputText = StringUtilities.getString(buffer, bytesRead);
                if (inputText.indexOf("?") != -1) {
                    int index = inputText.indexOf("?");
                    String message = inputBuffer + inputText.substring(0, index);
                    issueNumber = MessageHandler.getIssueNumber(message);
                    if (issueNumber == null) {
                        this.runProcess.destroy();
                        return -1;
                    }
                    outputStream.println(issueNumber);
                    outputStream.flush();
                    inputBuffer = new StringBuffer(inputText.substring(index + 1));
                    continue;
                }
                inputBuffer.append(inputText);
            }
            outputStream.close();
            errorThread.join();
            this.runProcess.waitFor();
            commandStatus = this.runProcess.exitValue();
            if (commandStatus != 0) {
                if (inputBuffer.length() + errorString.length() > 0) {
                    String commandErrorMessage = inputBuffer.toString() + errorString.toString();
                    if (!SecurityUtils.isUserAuthenticated(commandErrorMessage)) {
                        commandStatus = -100005;
                        MessageHandler.showSuccessMessage(inputBuffer.toString());
                    } else if (commandErrorMessage.indexOf("network error") != -1) {
                        commandStatus = -100006;
                        MessageHandler.showErrorMessage(errorString.toString());
                    } else {
                        int i;
                        String[] newCmdArray;
                        String cpkGapMessage;
                        boolean proceed;
                        this.allFilesHaveCPKGap = false;
                        this.cpkMergeRequired = false;
                        this.checkIfFilesHaveCPKGap(commandErrorMessage);
                        if (this.allFilesHaveCPKGap && (proceed = MessageHandler.showUserYesNoDialog(cpkGapMessage = "The following files have missing versions in the Change Package:\n" + this.filesWithCPKGap + "\n \n" + "Would you like AccuRev to automatically add these versions and proceed with promote?" + "\n \n" + "Click 'Yes' to proceed, 'No' to cancel the promote operation", "Promote", "Error"))) {
                            newCmdArray = new String[commandArray.length + 1];
                            newCmdArray[0] = commandArray[0];
                            newCmdArray[1] = commandArray[1];
                            newCmdArray[2] = "-g";
                            for (i = 2; i < commandArray.length; ++i) {
                                newCmdArray[i + 1] = commandArray[i];
                            }
                            commandStatus = this.exec(newCmdArray, workingDirectory);
                            cmd = "";
                            for (i = 0; i < newCmdArray.length; ++i) {
                                cmd = cmd + newCmdArray[i] + " ";
                            }
                        }
                        if (commandStatus != 0 || !this.allFilesHaveCPKGap) {
                            this.checkIfFilesRequireCPKMerge(commandErrorMessage);
                        }
                        if (this.cpkMergeRequired) {
                            String cpkMergeMessage = "For one or more of the versions to be promoted, an entry already exists \nin the specified change package. Moreover, the version to be promoted needs \nto be merged with the version in the existing entry. \n \nClick 'No' to cancel the Promote command now. \n \nClick 'Yes' to proceed with the Promote command. It will succeed only if \nthe changes to be promoted already include the current change package entry. \n \nIn either case, the change package will not be modified.\n";
                            proceed = MessageHandler.showUserYesNoDialog(cpkMergeMessage, "Promote", "Error");
                            if (proceed) {
                                newCmdArray = new String[commandArray.length + 1];
                                newCmdArray[0] = commandArray[0];
                                newCmdArray[1] = commandArray[1];
                                newCmdArray[2] = "-N";
                                for (i = 2; i < commandArray.length; ++i) {
                                    newCmdArray[i + 1] = commandArray[i];
                                }
                                commandStatus = this.exec(newCmdArray, workingDirectory);
                                cmd = "";
                                for (i = 0; i < newCmdArray.length; ++i) {
                                    cmd = cmd + newCmdArray[i] + " ";
                                }
                                MessageHandler.showSuccessMessage(cmd);
                            }
                        } else if (!this.allFilesHaveCPKGap && !this.cpkMergeRequired) {
                            MessageHandler.showErrorMessage(commandErrorMessage);
                        }
                    }
                }
            } else {
                MessageHandler.showSuccessMessage(inputBuffer.toString());
            }
        }
        catch (IOException e) {
            commandStatus = -100001;
        }
        catch (Exception e) {
            commandStatus = -100004;
        }
        return commandStatus;
    }

    private void checkIfFilesHaveCPKGap(String commandErrorMessage) {
        boolean bl = this.allFilesHaveCPKGap = commandErrorMessage.indexOf("Change package gap:") != -1 && commandErrorMessage.indexOf("Change package merge required:") == -1;
        if (this.allFilesHaveCPKGap) {
            this.filesWithCPKGap = "";
            while (commandErrorMessage.indexOf(":") != -1) {
                commandErrorMessage = commandErrorMessage.substring(commandErrorMessage.indexOf(":") + 1);
                this.filesWithCPKGap = this.filesWithCPKGap + commandErrorMessage.substring(0, commandErrorMessage.indexOf("\n")) + "\n";
            }
        }
    }

    private void checkIfFilesRequireCPKMerge(String commandErrorMessage) {
        this.cpkMergeRequired = commandErrorMessage.indexOf("Change package merge required:") != -1;
    }

    public int purgeElements(String workingDirectory, String elementListPath) {
        String[] commandArray = new String[]{accurevExecutable, "purge", "-l", elementListPath};
        return this.exec(commandArray, workingDirectory);
    }

    public int moveElement(String workingDirectory, String oldPath, String newPath) {
        String[] commandArray = new String[]{accurevExecutable, "move", oldPath, newPath};
        return this.exec(commandArray, workingDirectory);
    }

    public int updateWorkspace(String workingDirectory, boolean isPreview) {
        String[] commandArray = isPreview ? new String[]{accurevExecutable, "update", "-i"} : new String[]{accurevExecutable, "update", "-fx", "-Z"};
        int retValue = this.exec(commandArray, workingDirectory, true);
        if (retValue != 0 && retValue != -100001 && retValue != -100005) {
            MessageHandler.showErrorMessage(this.errorText.toString());
        }
        return retValue;
    }

    public int diffTwoFiles(String elementPath1, String elementPath2, String title1, String title2) {
        String[] commandArray = new String[]{diffExecutable, elementPath1, elementPath2, "-M", elementPath2, "--title1", title1, "--title2", title2};
        return this.execNoWait(commandArray, null);
    }

    public int elementStreamHistory(String workingDirectory, String elementName, String streamName, Collection historyData) {
        String[] as = new String[]{RunProcess.accurevExecutable, "hist", "-fx", "-s", streamName, elementName};
        HistoryParser historyParser = new HistoryParser();
        int commandStatus = this.exec(as, workingDirectory, historyParser);
        if (historyData != null) {
            historyData.clear();
            historyData.addAll(historyParser.getHistoryDataCollection());
        }
        try {
            historyParser.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
            commandStatus = -1;
        }
        return commandStatus;
    }

    public int elementDepotHistory(String workingDirectory, String elementPath, String depotName, Collection historyData) {
        String[] as = new String[]{RunProcess.accurevExecutable, "hist", "-fx", "-p", depotName, elementPath};
        HistoryParser historyParser = new HistoryParser();
        int commandStatus = this.exec(as, workingDirectory, historyParser);
        if (historyData != null) {
            historyData.clear();
            historyData.addAll(historyParser.getHistoryDataCollection());
        }
        try {
            historyParser.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
            commandStatus = -1;
        }
        return commandStatus;
    }

    public String getStreamVersion(String workingDirectory, String depotName, String streamName, String fileEID) {
        String retValue = "";
        try {
            File queryFile = null;
            PrintStream out = null;
            try {
                queryFile = File.createTempFile("query", null);
                queryFile.deleteOnExit();
                out = new PrintStream(new FileOutputStream(queryFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            out.println("<acRequest> <stat>");
            out.println("<depot>" + depotName + "</depot>");
            out.println("<ver_spec1>" + streamName + "</ver_spec1>");
            out.println("<elements>");
            out.println("<e eid=\"" + fileEID + "\"></e>");
            out.println("</elements>");
            out.println("</stat> </acRequest>");
            out.flush();
            out.close();
            String[] cmds = new String[]{accurevExecutable, "xml", "-l", queryFile.getAbsolutePath()};
            AcResponseParser acParser = new AcResponseParser(class$com$accurev$common$data$AcResponseData == null ? (class$com$accurev$common$data$AcResponseData = ElementProcess.class$("com.accurev.common.data.AcResponseData")) : class$com$accurev$common$data$AcResponseData);
            this.exec(cmds, workingDirectory, acParser);
            Vector acData = new Vector();
            if (acData != null) {
                acData.clear();
                acData.addAll(acParser.getAcResponseCollection());
            }
            AcResponseData firstElementData = (AcResponseData)acData.get(0);
            retValue = firstElementData.getVirtual();
            queryFile.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        return retValue;
    }

    public int undefunctElement(String wspaceDir, String filePath) {
        Vector<String> cmdVector = new Vector<String>();
        cmdVector.add(accurevExecutable);
        cmdVector.add("undefunct");
        cmdVector.add("-L");
        cmdVector.add(wspaceDir);
        cmdVector.add(filePath);
        String[] cmdArray = cmdVector.toArray(new String[0]);
        return this.exec(cmdArray, wspaceDir);
    }

    public int purgeElement(String wspaceDir, String eid) {
        String[] cmds = new String[]{accurevExecutable, "purge", "-L", wspaceDir, "-e", eid};
        return this.exec(cmds, wspaceDir);
    }

    public String getExtraFileStat(String wspaceDir, String filePath) {
        String extraStat = "";
        try {
            String[] cmdArray = new String[]{accurevExecutable, "stat", "-X", "-L", wspaceDir, filePath};
            if (this.exec(cmdArray, null) == 0) {
                extraStat = this.responseText.toString();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return extraStat;
    }

    public int statusElementsForStream(String streamName, Class containerClass, Collection statusData, String path) {
        String[] commandArray = new String[]{accurevExecutable, "files", "-fx", "-s", streamName, path};
        StatusParser statusParser = new StatusParser(containerClass);
        int commandStatus = this.exec(commandArray, null, statusParser);
        if (statusData != null) {
            statusData.clear();
            statusData.addAll(statusParser.getElementStatusCollection());
        }
        return commandStatus;
    }

    public Vector getDirStructForStream(String streamName, String path) {
        Vector<String> cmdVector = new Vector<String>();
        cmdVector.add(accurevExecutable);
        cmdVector.add("dirstruct");
        cmdVector.add("-fx");
        cmdVector.add("-s");
        cmdVector.add(streamName);
        cmdVector.add(path);
        String[] cmds = cmdVector.toArray(new String[0]);
        StreamDirStructParser streamsDirStructParser = new StreamDirStructParser();
        this.exec(cmds, null, streamsDirStructParser);
        return streamsDirStructParser.getDirStruct();
    }

    public int statusElementsForStream(String streamName, int searchID, String directoryPath, Class containerClass, Collection statusData) {
        String[] searchOptions = this.getSearchStatusOption(searchID);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(accurevExecutable);
        commandList.add("stat");
        commandList.add("-s");
        commandList.add(streamName);
        commandList.add("-fex");
        for (int i = 0; i < searchOptions.length; ++i) {
            commandList.add(searchOptions[i]);
        }
        if (searchID != 14 && !directoryPath.equals(Constants.TWO_CHARACTER_RELATIVE_PATH_PREFIX)) {
            commandList.add("-R");
            commandList.add(directoryPath);
        }
        int size = commandList.size();
        String[] commandArray = new String[size];
        int i = 0;
        Iterator iter = commandList.iterator();
        while (iter.hasNext()) {
            String element;
            commandArray[i] = element = (String)iter.next();
            ++i;
        }
        StatusParser statusParser = new StatusParser(containerClass);
        int commandStatus = this.exec(commandArray, null, statusParser);
        if (statusData != null) {
            statusData.clear();
            statusData.addAll(statusParser.getElementStatusCollection());
        }
        return commandStatus;
    }

    protected String[] getSearchStatusOption(int searchType) {
        String[] searchOption = new String[]{""};
        switch (searchType) {
            case 9: {
                searchOption = new String[]{"-a"};
                break;
            }
            case 0: {
                searchOption = new String[]{"-x"};
                break;
            }
            case 1: {
                searchOption = new String[]{"-p"};
                break;
            }
            case 2: {
                searchOption = new String[]{"-m"};
                break;
            }
            case 3: {
                searchOption = new String[]{"-k"};
                break;
            }
            case 4: {
                searchOption = new String[]{"-n"};
                break;
            }
            case 5: {
                searchOption = new String[]{"-d"};
                break;
            }
            case 6: {
                searchOption = new String[]{"-o"};
                break;
            }
            case 7: {
                searchOption = new String[]{"-md"};
                break;
            }
            case 8: {
                searchOption = new String[]{"-D"};
                break;
            }
            case 11: {
                searchOption = new String[]{"-R"};
                break;
            }
            case 12: {
                searchOption = new String[]{"-x", "-R"};
                break;
            }
            case 13: {
                searchOption = new String[]{"-B", "-o"};
                break;
            }
            case 14: {
                searchOption = new String[]{"-i"};
                break;
            }
            case 15: {
                searchOption = new String[]{"-M"};
                break;
            }
            case 16: {
                searchOption = new String[]{"-U"};
            }
        }
        return searchOption;
    }

    private int execWithTaskProgressBar(String[] cmdArray, String progressTitle, String workingDirectory, ProcessStatusListener listener) {
        this.commandStatus = 0;
        this.execNoWait(cmdArray, workingDirectory);
        String taskID = "0";
        try {
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(this.input));
            String taskLine = "";
            while (!(taskLine = inputReader.readLine()).startsWith("taskid:")) {
            }
            taskID = taskLine.substring(7).trim();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer errorString = new StringBuffer();
        RunProcess.ErrorReaderThread errorThread = new RunProcess.ErrorReaderThread(errorString);
        errorThread.start();
        StringBuffer inputString = new StringBuffer();
        RunProcess.InputReaderThread inputThread = new RunProcess.InputReaderThread(inputString);
        inputThread.start();
        boolean isProcessComplete = false;
        for (int i = 0; i < 10; ++i) {
            try {
                this.runProcess.exitValue();
                isProcessComplete = true;
                break;
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        boolean processDestroyed = false;
        if (!isProcessComplete && listener != null) {
            listener.notifyProcessId(taskID);
            listener.initializeListener();
        }
        if (!processDestroyed) {
            try {
                inputThread.join();
                errorThread.join();
                this.runProcess.waitFor();
                this.commandStatus = this.runProcess.exitValue();
                if (this.commandStatus != 0) {
                    String errorMessageText = this.errorText.toString();
                    if (!SecurityUtils.isUserAuthenticated(errorMessageText)) {
                        this.commandStatus = -100005;
                    } else {
                        if (this.parseHandler != null && this.parseHandler.getMessageData() != null) {
                            errorMessageText = errorMessageText + this.parseHandler.getMessageData();
                        }
                        if (errorMessageText.length() > 0) {
                            if (errorMessageText.indexOf("network error") != -1) {
                                this.commandStatus = -100006;
                            }
                            MessageHandler.showErrorMessage(errorMessageText);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                this.commandStatus = -100002;
            }
        }
        return this.commandStatus;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

