/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.data.FieldData;
import com.accurev.common.data.QueryData;
import com.accurev.common.data.XMLTag;
import com.accurev.common.parsers.GenericXMLParser;
import com.accurev.common.parsers.IssueParser;
import com.accurev.common.process.RunProcess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryProcess
extends RunProcess {
    private IssueParser issueParser;

    public List getUserQueries(String depotName, String userName) {
        String[] cmds = new String[]{accurevExecutable, "getconfig", "-u", userName, "-p", depotName, "-r", "query.xml"};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(cmds, null, parser);
        List queries = new ArrayList();
        if (parser.getTagList() != null && parser.getTagList().size() > 0) {
            queries = this.retrieveQueryList(parser.getTagList());
        }
        return queries;
    }

    public List getPublicQueries(String depotName) {
        String[] cmds = new String[]{accurevExecutable, "getconfig", "-p", depotName, "-r", "publicQuery.xml"};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(cmds, null, parser);
        List queries = new ArrayList();
        if (parser.getTagList() != null && parser.getTagList().size() > 0) {
            queries = this.retrieveQueryList(parser.getTagList());
        }
        return queries;
    }

    public Map runQuery(String queryXML) {
        File queryFile = null;
        PrintStream out = null;
        try {
            queryFile = File.createTempFile("query", null);
            queryFile.deleteOnExit();
            out = new PrintStream(new FileOutputStream(queryFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        out.println(queryXML);
        out.flush();
        out.close();
        String[] cmds = new String[]{accurevExecutable, "xml", "-l", queryFile.getAbsolutePath()};
        this.issueParser = new IssueParser();
        this.exec(cmds, null, this.issueParser);
        queryFile.delete();
        return this.issueParser.getIssuesMap();
    }

    private List retrieveQueryList(List tagList) {
        XMLTag root = (XMLTag)tagList.get(0);
        List tList = root.getTags();
        ArrayList<QueryData> queries = new ArrayList<QueryData>();
        for (int i = 0; i < tList.size(); ++i) {
            XMLTag queryTag = (XMLTag)tList.get(i);
            if (!queryTag.getName().equals("query")) continue;
            QueryData queryData = new QueryData();
            queryData = new QueryData();
            queryData.setName(queryTag.getAttributeValue("name"));
            queryData.setDefault(Boolean.valueOf(queryTag.getAttributeValue("setAsDefault")));
            queryData.setPublic(Boolean.valueOf(queryTag.getAttributeValue("isPublic")));
            queryData.setOwnerID(queryTag.getAttributeValue("ownerID"));
            this.setQueryData(queryTag, queryData);
            queries.add(queryData);
        }
        return queries;
    }

    private void setQueryData(XMLTag queryTag, QueryData queryData) {
        List itList = queryTag.getTags();
        ArrayList<FieldData> fields = new ArrayList<FieldData>();
        for (int i = 0; i < itList.size(); ++i) {
            XMLTag tag = (XMLTag)itList.get(i);
            if (tag.getName().equalsIgnoreCase("field")) {
                FieldData fData = new FieldData();
                fData.setFieldName(tag.getAttributeValue("name"));
                fData.setWidth(tag.getAttributeValue("width"));
                fData.setSortOrder(tag.getAttributeValue("sort"));
                fData.setSortSeqNum(tag.getAttributeValue("sortSeqNum"));
                fields.add(fData);
                continue;
            }
            if (tag.getName().equalsIgnoreCase("ranking")) {
                List issueTags = tag.getTags();
                ArrayList<String> issues = new ArrayList<String>();
                for (int j = 0; j < issueTags.size(); ++j) {
                    XMLTag issueTag = (XMLTag)issueTags.get(j);
                    issues.add(issueTag.getContent());
                }
                queryData.setIssueRanking(issues);
                continue;
            }
            if (!tag.getName().equalsIgnoreCase("queryIssue")) continue;
            queryData.setQueryXML(tag.toXML());
        }
        queryData.setFields(fields);
    }

    public Map getIssueRankingListMap(String depotName, String userName) {
        String[] cmds = new String[]{accurevExecutable, "getconfig", "-u", userName, "-p", depotName, "-r", "issue_ranking.xml"};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(cmds, null, parser);
        Map map = new HashMap();
        if (parser.getTagList() != null && parser.getTagList().size() > 0) {
            map = this.retrieveIssueRankingListMap(parser.getTagList());
        }
        return map;
    }

    private Map retrieveIssueRankingListMap(List tagList) {
        XMLTag root = (XMLTag)tagList.get(0);
        List listTags = root.getTags();
        HashMap listMap = new HashMap();
        for (int i = 0; i < listTags.size(); ++i) {
            XMLTag listTag = (XMLTag)listTags.get(i);
            List issueTagList = listTag.getTags();
            ArrayList<String> issues = new ArrayList<String>();
            for (int j = 0; j < issueTagList.size(); ++j) {
                XMLTag issueTag = (XMLTag)issueTagList.get(j);
                issues.add(issueTag.getAttributeValue("id"));
            }
            listMap.put(listTag.getAttributeValue("name"), issues);
        }
        return listMap;
    }
}

