/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.process;

import com.accurev.common.CacheManager;
import com.accurev.common.MessageHandler;
import com.accurev.common.data.StreamData;
import com.accurev.common.data.WorkspaceData;
import com.accurev.common.data.WorkspaceInformation;
import com.accurev.common.parsers.DepotParser;
import com.accurev.common.parsers.GenericXMLParser;
import com.accurev.common.parsers.HistoryParser;
import com.accurev.common.parsers.ShowStreamsParser;
import com.accurev.common.parsers.ShowTriggersParser;
import com.accurev.common.parsers.ShowWorkspaceParser;
import com.accurev.common.process.RunProcess;
import com.accurev.common.utils.SecurityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.xml.sax.SAXException;

public class StreamProcess
extends RunProcess {
    protected static final String INFORMATION_COMMAND = "info";
    protected static final String SHOW_COMMAND = "show";
    protected static final String GET_CONFIG_COMMAND = "getconfig";
    protected static final String XML_COMMAND = "xml";
    public static final String SYNC_TIME_COMMAND = "synctime";
    protected static final String ALL_OPTION = "-a";
    protected static final String FORMAT_XML_OPTION = "-fx";
    protected static final String FORMAT_XML_WITH_HIDDEN_OPTION = "-fix";
    protected static final String LOCATION_OPTION = "-l";
    protected static final String DEPOT_OPTION = "-p";
    protected static final String CONFIGURATION_OPTION = "-r";
    protected static final String STREAM_OPTION = "-s";
    protected static final String USER_OPTION = "-u";
    protected static final String CHANGE_PACKAGE_FIELDS_ATTRIBUTE = "cpk_fields.xml";
    protected static final String CHANGE_PACKAGE_QUERY_ATTRIBUTE = "cpk_promote_queries.xml";
    protected static final String QUERY_XML_ATTRIBUTE = "query.xml";
    protected static final String SCHEMA_XML_ATTRIBUTE = "schema.xml";
    protected static final String STREAMS_ATTRIBUTE = "streams";
    protected static final String DEPOTS_ATTRIBUTE = "depots";
    protected static final String TRIGGERS_ATTRIBUTE = "triggers";
    protected static final String USERS_ATTRIBUTE = "users";
    protected static final String WORKSPACES_ATTRIBUTE = "wspaces";
    protected static final String WORKSPACE_NAME_TAG = "Workspace/ref:";
    protected static final String BASIS_STREAM_NAME_TAG = "Basis:";
    protected static final String WORKSPACE_DIRECTORY_PATH_TAG = "Top:";
    protected static final String PRINCIPAL_USER_TAG = "Principal:";
    protected static final String DEPOT_NAME_TAG = "Depot:";
    protected static final String ACCUREV_BIN_TAG = "ACCUREV_BIN:";
    protected static final String SERVER_NAME_TAG = "Server name:";
    protected static final String PORT_TAG = "Port:";

    public WorkspaceInformation runInfo(String path) {
        WorkspaceInformation wspaceData = new WorkspaceInformation();
        this.runInfo(wspaceData, path, true);
        return wspaceData;
    }

    public String getAccurevBinPath() {
        String[] commands = new String[]{accurevExecutable, INFORMATION_COMMAND};
        this.exec(commands, null);
        String infoString = this.getResponseText().toString();
        return StreamProcess.extractFieldValue(infoString, ACCUREV_BIN_TAG);
    }

    public void runInfo(WorkspaceInformation wInformation, String path, boolean showError) {
        String[] commands = new String[]{accurevExecutable, INFORMATION_COMMAND};
        if (this.exec(commands, path, true) == 0) {
            String infoString = this.getResponseText().toString();
            wInformation.setPrincipalUserName(StreamProcess.extractFieldValue(infoString, PRINCIPAL_USER_TAG));
            wInformation.setDepotName(StreamProcess.extractFieldValue(infoString, DEPOT_NAME_TAG));
            wInformation.setWorkspaceName(StreamProcess.extractFieldValue(infoString, WORKSPACE_NAME_TAG));
            wInformation.setBasisStreamName(StreamProcess.extractFieldValue(infoString, BASIS_STREAM_NAME_TAG));
            wInformation.setWorkspaceDirectoryPath(StreamProcess.extractFieldValue(infoString, WORKSPACE_DIRECTORY_PATH_TAG));
            wInformation.setAccuRevPath(StreamProcess.extractFieldValue(infoString, ACCUREV_BIN_TAG));
            wInformation.setServerName(StreamProcess.extractFieldValue(infoString, SERVER_NAME_TAG));
            wInformation.setPort(StreamProcess.extractFieldValue(infoString, PORT_TAG));
        } else {
            String infoString = this.getResponseText().toString();
            wInformation.setPrincipalUserName(StreamProcess.extractFieldValue(infoString, PRINCIPAL_USER_TAG));
            wInformation.setAccuRevPath(StreamProcess.extractFieldValue(infoString, ACCUREV_BIN_TAG));
        }
        SecurityUtils.binPath = wInformation.getAccurevBinPath();
        if (showError && !wInformation.isValid()) {
            MessageHandler.showSuccessMessage("The path is not associated with an AccuRev Workspace: " + path);
            MessageHandler.showSuccessMessage("The results of the AccuRev 'info' command is below:");
            if (this.getResponseText().length() > 0) {
                MessageHandler.showSuccessMessage(this.getResponseText().toString() + "\n");
            }
            if (this.getErrorText().length() > 0) {
                MessageHandler.showSuccessMessage(this.getErrorText().toString() + "\n");
            }
        }
    }

    public Vector runShowWorkspaces(boolean showAll, boolean showHidden) {
        String[] commands = new String[showAll ? 5 : 4];
        int index = 0;
        commands[index++] = accurevExecutable;
        commands[index++] = SHOW_COMMAND;
        String string = commands[index++] = showHidden ? FORMAT_XML_WITH_HIDDEN_OPTION : FORMAT_XML_OPTION;
        if (showAll) {
            commands[index++] = ALL_OPTION;
        }
        commands[index++] = WORKSPACES_ATTRIBUTE;
        ShowWorkspaceParser swParser = new ShowWorkspaceParser();
        this.exec(commands, null, swParser);
        return swParser.getWorkspaceShowCollection();
    }

    public List runGetConfigChangePackage(String depotName) {
        String[] commands = new String[]{accurevExecutable, GET_CONFIG_COMMAND, DEPOT_OPTION, depotName, CONFIGURATION_OPTION, CHANGE_PACKAGE_QUERY_ATTRIBUTE};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(commands, null, parser);
        return parser.getTagList();
    }

    public Vector runShowAllStreams(String depotName) {
        return this.getStreams(depotName, false);
    }

    public Vector getStreams(String depotName, boolean includeHidden) {
        String format = FORMAT_XML_OPTION;
        if (includeHidden) {
            format = FORMAT_XML_WITH_HIDDEN_OPTION;
        }
        String[] as = new String[]{RunProcess.accurevExecutable, SHOW_COMMAND, format, DEPOT_OPTION, depotName, STREAMS_ATTRIBUTE};
        ShowStreamsParser streamParser = new ShowStreamsParser();
        this.exec(as, null, streamParser);
        Vector collection = new Vector();
        collection.clear();
        collection.addAll(streamParser.getStreamInformationCollection());
        try {
            streamParser.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return collection;
    }

    public String runShowStream(String depotName, String streamId) {
        String streamName = null;
        String[] as = new String[]{RunProcess.accurevExecutable, SHOW_COMMAND, FORMAT_XML_OPTION, DEPOT_OPTION, depotName, STREAM_OPTION, streamId, STREAMS_ATTRIBUTE};
        ShowStreamsParser streamParser = new ShowStreamsParser();
        this.exec(as, null, streamParser);
        Vector collection = streamParser.getStreamInformationCollection();
        StreamData sData = (StreamData)collection.get(0);
        if (sData != null) {
            streamName = sData.getName();
        }
        return streamName;
    }

    public StreamData getStreamDetails(String streamName) {
        ShowStreamsParser streamParser = new ShowStreamsParser();
        String[] as = new String[]{RunProcess.accurevExecutable, SHOW_COMMAND, FORMAT_XML_OPTION, STREAM_OPTION, streamName, STREAMS_ATTRIBUTE};
        this.exec(as, null, streamParser);
        Vector collection = streamParser.getStreamInformationCollection();
        StreamData sData = null;
        if (collection != null && collection.size() > 0) {
            sData = (StreamData)collection.get(0);
        }
        return sData;
    }

    public Vector runShowDepots() {
        String[] as = new String[]{RunProcess.accurevExecutable, SHOW_COMMAND, FORMAT_XML_OPTION, DEPOTS_ATTRIBUTE};
        DepotParser depotParser = new DepotParser();
        this.exec(as, null, depotParser);
        Vector collection = new Vector();
        collection.clear();
        collection.addAll(depotParser.getDepotInformationCollection());
        try {
            depotParser.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return collection;
    }

    public StreamData runShowStreams(String depotName, String streamName) {
        Vector streamCollection = this.runShowAllStreams(depotName);
        StreamData sData = new StreamData();
        for (int i = 0; i < streamCollection.size() && !(sData = (StreamData)streamCollection.get(i)).getName().equalsIgnoreCase(streamName); ++i) {
        }
        return sData;
    }

    public Vector runShowStreamsType(String depotName, int streamType) {
        Vector streamNames = this.runShowAllStreams(depotName);
        Vector<StreamData> streams = new Vector<StreamData>();
        for (int i = 0; i < streamNames.size(); ++i) {
            StreamData information = (StreamData)streamNames.get(i);
            if (!information.getType().equals(this.getStreamType(streamType))) continue;
            streams.add(information);
        }
        return streams;
    }

    public List runGetConfigSchema(String depotName) {
        String[] commands = new String[]{accurevExecutable, GET_CONFIG_COMMAND, DEPOT_OPTION, depotName, CONFIGURATION_OPTION, SCHEMA_XML_ATTRIBUTE};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(commands, null, parser);
        return parser.getTagList();
    }

    public List runShowTriggers(String depotName) {
        String[] commands = new String[]{accurevExecutable, SHOW_COMMAND, FORMAT_XML_OPTION, DEPOT_OPTION, depotName, TRIGGERS_ATTRIBUTE};
        ShowTriggersParser parser = new ShowTriggersParser();
        this.exec(commands, null, parser);
        return parser.getTriggerData();
    }

    public List runGetConfigUserQuery(String depotName, String userName) {
        String[] commands = new String[]{accurevExecutable, GET_CONFIG_COMMAND, DEPOT_OPTION, depotName, USER_OPTION, userName, CONFIGURATION_OPTION, QUERY_XML_ATTRIBUTE};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(commands, null, parser);
        return parser.getTagList();
    }

    public List runXML(String fileName) {
        String[] commands = new String[]{accurevExecutable, XML_COMMAND, LOCATION_OPTION, fileName};
        GenericXMLParser parser = new GenericXMLParser();
        this.exec(commands, null, parser);
        return parser.getTagList();
    }

    public void runSyncTime() {
        String[] commands = new String[]{accurevExecutable, SYNC_TIME_COMMAND};
        this.exec(commands, null);
    }

    public int createNewWorkspace(WorkspaceData workspaceInfo) {
        return this.createNewWorkspace(workspaceInfo, false);
    }

    public int createNewWorkspace(WorkspaceData workspaceInfo, boolean pickAndChoose) {
        ArrayList<String> commandToExecute = new ArrayList<String>();
        commandToExecute.add(RunProcess.accurevExecutable);
        commandToExecute.add("mkws");
        if (pickAndChoose) {
            commandToExecute.add("-i");
        }
        commandToExecute.add("-w");
        commandToExecute.add(workspaceInfo.getName());
        commandToExecute.add("-b");
        commandToExecute.add(workspaceInfo.getBasisStreamName());
        if (workspaceInfo.getKind() != null) {
            commandToExecute.add(workspaceInfo.getKind());
        }
        if (workspaceInfo.getEndOfLineType() != null) {
            commandToExecute.add(workspaceInfo.getEndOfLineType());
        }
        commandToExecute.add(LOCATION_OPTION);
        commandToExecute.add(workspaceInfo.getStoragePath() + "/" + workspaceInfo.getName());
        Iterator iter = commandToExecute.iterator();
        String[] commandArray = new String[commandToExecute.size()];
        int asCount = 0;
        while (iter.hasNext()) {
            commandArray[asCount++] = (String)iter.next();
        }
        return this.exec(commandArray, null, false);
    }

    public int createNewStream(StreamData streamData, boolean nowTimeBase, String tranNumber) {
        ArrayList<String> commandToExecute = new ArrayList<String>();
        commandToExecute.add(RunProcess.accurevExecutable);
        commandToExecute.add(streamData.getType().equals("snapshot") ? "mksnap" : "mkstream");
        commandToExecute.add(STREAM_OPTION);
        commandToExecute.add(streamData.getName());
        commandToExecute.add("-b");
        commandToExecute.add(streamData.getBasisName());
        if (streamData.getType().equals("passthrough")) {
            commandToExecute.add("-kp");
        }
        if (nowTimeBase) {
            commandToExecute.add("-t");
            commandToExecute.add("now");
        } else if (tranNumber != null && !tranNumber.equals("")) {
            commandToExecute.add("-t");
            commandToExecute.add(tranNumber);
        } else if (!streamData.getBasisStreamTime().equals("")) {
            commandToExecute.add("-t");
            commandToExecute.add(streamData.getBasisStreamTime());
        }
        String[] commandArray = commandToExecute.toArray(new String[0]);
        return this.exec(commandArray, null, false);
    }

    public int removeStream(String streamName) {
        ArrayList<String> commandToExecute = new ArrayList<String>();
        commandToExecute.add(RunProcess.accurevExecutable);
        commandToExecute.add("remove");
        commandToExecute.add("stream");
        commandToExecute.add(streamName);
        String[] commandArray = commandToExecute.toArray(new String[0]);
        return this.exec(commandArray, null, false);
    }

    public int reactivateStream(String streamName) {
        ArrayList<String> commandToExecute = new ArrayList<String>();
        commandToExecute.add(RunProcess.accurevExecutable);
        commandToExecute.add("reactivate");
        commandToExecute.add("stream");
        commandToExecute.add(streamName);
        String[] commandArray = commandToExecute.toArray(new String[0]);
        return this.exec(commandArray, null, false);
    }

    public int getStreamHistory(String workingDirectory, String streamName, String userName, String from, String to, String step, String commentFilter, boolean showVersions, Collection transData) {
        Vector<String> cmdVector = new Vector<String>();
        cmdVector.add(accurevExecutable);
        cmdVector.add("hist");
        cmdVector.add(showVersions ? FORMAT_XML_OPTION : "-fxt");
        if (!"".equals(commentFilter)) {
            cmdVector.add("-c");
            cmdVector.add(commentFilter);
        }
        if (!"".equals(userName)) {
            cmdVector.add(USER_OPTION);
            cmdVector.add(userName);
        }
        cmdVector.add("-t" + from + "-" + to + (step.equals("") ? "" : "." + step));
        cmdVector.add(ALL_OPTION);
        cmdVector.add(STREAM_OPTION);
        cmdVector.add(streamName);
        String[] commandArray = cmdVector.toArray(new String[0]);
        HistoryParser historyParser = new HistoryParser();
        int commandStatus = this.exec(commandArray, workingDirectory, historyParser);
        if (transData != null) {
            transData.clear();
            transData.addAll(historyParser.getHistoryDataCollection());
        }
        return commandStatus;
    }

    public String getStreamType(int streamType) {
        String streamOption = "";
        switch (streamType) {
            case 1: {
                streamOption = "workspace";
                break;
            }
            case 2: {
                streamOption = "snapshot";
                break;
            }
            case 3: {
                streamOption = "normal";
                break;
            }
            case 4: {
                streamOption = "passthrough";
            }
        }
        return streamOption;
    }

    public String getWorkspaceDir(String wspaceName) {
        String dirString = "";
        String[] cmds = new String[]{accurevExecutable, "start", "-c", "pwd", CONFIGURATION_OPTION, wspaceName};
        if (this.exec(cmds, null) == 0) {
            dirString = this.getResponseText().toString();
            dirString = dirString.toString().replace('/', File.separatorChar);
        }
        return dirString.trim();
    }

    public static final String extractFieldValue(String buffer, String fieldTag) {
        String fieldValue = null;
        int index = buffer.indexOf(fieldTag);
        if (index >= 0) {
            fieldValue = buffer.substring(index + fieldTag.length());
            if ((index = fieldValue.indexOf(10)) >= 0) {
                fieldValue = fieldValue.substring(0, index);
            }
            fieldValue = fieldValue.trim();
        }
        return fieldValue;
    }

    public List getStreamHierarchy(String depotName, String streamName) {
        StreamData lStream;
        ArrayList<StreamData> hierarchyList = new ArrayList<StreamData>();
        if (hierarchyList.size() > 0) {
            return hierarchyList;
        }
        String currentBasis = streamName;
        while (currentBasis != null && currentBasis.length() > 0 && (lStream = CacheManager.getInstance().getStreamDataByName(depotName, currentBasis)) != null) {
            hierarchyList.add(lStream);
            currentBasis = lStream.getBasisName();
        }
        return hierarchyList;
    }
}

