/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DateTimeUtilities {
    public static final String DAY_FORMAT = "yyyy-MM-dd";
    public static final String MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String SECOND_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String GRANULARITY_DAY = "day";
    public static final String GRANULARITY_MINUTE = "minute";
    public static final String GRANULARITY_SECOND = "second";
    public static final int GRANULARITY_DAY_INDEX = 0;
    public static final int GRANULARITY_MINUTE_INDEX = 1;
    public static final int GRANULARITY_SECOND_INDEX = 2;
    protected static final ArrayList GRANULARITY_VALUES = new ArrayList();
    protected static final ArrayList GRANULARITY_FORMATTERS = new ArrayList();

    public static String accurevTimestampToDateTime(Long timestamp, String granularity) {
        int gIndex = DateTimeUtilities.getGranularityIndex(granularity);
        return DateTimeUtilities.accurevTimestampToDateTime(timestamp, gIndex);
    }

    public static String accurevTimestampToDateTime(Long timestamp) {
        return DateTimeUtilities.accurevTimestampToDateTime(timestamp, 2);
    }

    public static String accurevTimestampToDateTime(Long timestamp, int granularity) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat formatter = (SimpleDateFormat)GRANULARITY_FORMATTERS.get(granularity);
        long lValue = timestamp * 1000L;
        return formatter.format(new Date(lValue));
    }

    public static int getGranularityIndex(String granularity) {
        if (granularity == null) {
            return 2;
        }
        int index = GRANULARITY_VALUES.indexOf(granularity);
        if (index < 0) {
            index = 2;
        }
        return index;
    }

    static {
        GRANULARITY_VALUES.add(GRANULARITY_DAY);
        GRANULARITY_VALUES.add(GRANULARITY_MINUTE);
        GRANULARITY_VALUES.add(GRANULARITY_SECOND);
        GRANULARITY_FORMATTERS.add(new SimpleDateFormat(DAY_FORMAT));
        GRANULARITY_FORMATTERS.add(new SimpleDateFormat(MINUTE_FORMAT));
        GRANULARITY_FORMATTERS.add(new SimpleDateFormat(SECOND_FORMAT));
    }
}

