/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.utils;

import com.accurev.common.MessageHandler;
import com.accurev.common.process.StreamProcess;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class SecurityUtils {
    public static String binPath;
    protected static final String NOT_AUTH = "(not authenticated)";
    protected static final String NOT_LOGGED_IN = "(not logged in)";
    protected static final String UNKNOWN = "(unknown)";
    protected static final String INACTIVE = "(inactive)";
    protected static final String USER_NOT_AUTH = "Not authenticated";

    public static boolean isUserAuthenticated(String message) {
        return message.indexOf(USER_NOT_AUTH) == -1;
    }

    public static boolean isValidLogin(String message) {
        return message.indexOf(NOT_AUTH) < 0 && message.indexOf(NOT_LOGGED_IN) < 0 && message.indexOf(UNKNOWN) < 0 && message.indexOf(INACTIVE) < 0;
    }

    public static String getCurrentServer() {
        Vector servers = SecurityUtils.parseServers();
        if (servers.isEmpty()) {
            return null;
        }
        return (String)servers.firstElement();
    }

    private static File getAcClientFile() {
        File acclientFile = null;
        if (binPath == null) {
            StreamProcess sProcess = new StreamProcess();
            binPath = sProcess.getAccurevBinPath();
        }
        if (binPath != null && !binPath.equals("")) {
            acclientFile = new File(binPath + File.separator + "acclient.cnf");
        }
        return acclientFile;
    }

    public static Vector parseServers() {
        Vector<String> servers = new Vector<String>();
        try {
            int bytesRead;
            File acclientFile = SecurityUtils.getAcClientFile();
            if (acclientFile == null) {
                return servers;
            }
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(acclientFile));
            byte[] buffer = new byte[1024];
            StringBuffer acclientText = new StringBuffer();
            while ((bytesRead = input.read(buffer)) > 0) {
                acclientText.append(new String(buffer, 0, bytesRead));
            }
            StringTokenizer tkz = new StringTokenizer(acclientText.toString(), "\t\r\f\n");
            while (tkz.countTokens() != 0) {
                servers.add(tkz.nextToken().substring(10));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("FileNotFoundException!");
        }
        catch (IOException e) {
            System.err.println("IOException!");
        }
        return servers;
    }

    public static boolean isUserNameContainInvalidChars(String userName) {
        boolean invalidCharacterFound = false;
        for (int i = 0; i < userName.length(); ++i) {
            char c = userName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isDigit(c) || c == '_' || c == '@' || c == '.' || c == '-' || c == ' ') continue;
            invalidCharacterFound = true;
            break;
        }
        return !invalidCharacterFound;
    }

    public static void generateServers(Vector servers) {
        try {
            File acclientFile = SecurityUtils.getAcClientFile();
            if (acclientFile == null) {
                return;
            }
            PrintStream out = new PrintStream(new FileOutputStream(acclientFile));
            for (int i = 0; i < servers.size(); ++i) {
                out.println("SERVERS = " + servers.elementAt(i));
                out.flush();
            }
            out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isUserNameValid(String userName) {
        if (userName.length() < 1) {
            MessageHandler.showErrorMessage("User Name must contain at least 1 character.");
            return false;
        }
        if (!SecurityUtils.isUserNameContainInvalidChars(userName)) {
            MessageHandler.showErrorMessage("User Name is invalid.");
            return false;
        }
        return true;
    }
}

