/*
 * Decompiled with CFR 0.152.
 */
package com.accurev.common.utils;

import com.accurev.common.Constants;

public class StringUtilities {
    public static String replaceAll(String oString, String oldString, String newString) {
        int index = oString.indexOf(oldString);
        if (index < 0) {
            return oString;
        }
        StringBuffer buffer = new StringBuffer(oString);
        while (index >= 0) {
            buffer.replace(index, index + oldString.length(), newString);
            oString = buffer.toString();
            index += newString.length();
            index = oString.indexOf(oldString, index);
        }
        return oString;
    }

    public static String convertToHTML(String source) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (c == '\n') {
                buffer.append("<br>");
                continue;
            }
            if (c == '\t') {
                buffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                continue;
            }
            if (c == ' ') {
                buffer.append("&nbsp;");
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String toXMLString(String content) {
        if (content == null || content.length() == 0) {
            return content;
        }
        for (int findx = 0; findx < 5; ++findx) {
            String unquotedString = Constants.QUOTED_ARRAY[findx][0];
            String quotedString = Constants.QUOTED_ARRAY[findx][1];
            content = StringUtilities.replaceAll(content, unquotedString, quotedString);
        }
        return content;
    }

    public static String toStandardString(String content) {
        if (content == null || content.length() == 0) {
            return content;
        }
        for (int findx = 0; findx < 5; ++findx) {
            String unquotedString = Constants.QUOTED_ARRAY[findx][0];
            String quotedString = Constants.QUOTED_ARRAY[findx][1];
            content = StringUtilities.replaceAll(content, quotedString, unquotedString);
        }
        return content;
    }

    public static final String getString(byte[] byteArray, int numberOfBytes) {
        if (byteArray == null) {
            return null;
        }
        return new String(byteArray, 0, numberOfBytes);
    }

    public static final String replaceInvalidCharacters(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace('\r', ' ');
        text = text.replace('\t', ' ');
        return text;
    }

    public static String flattenText(String text) {
        StringBuffer buffer = new StringBuffer();
        boolean skipAdjacentLineSeparator = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(" /");
                }
                skipAdjacentLineSeparator = true;
                continue;
            }
            buffer.append(c);
            skipAdjacentLineSeparator = false;
        }
        return buffer.toString();
    }
}

