/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.nio.charset.Charset;
import jetbrains.buildServer.StreamGobbler;
import org.jetbrains.annotations.NotNull;

public final class ExecResult {
    private int myExitCode = -1;
    private String myStdout = "";
    private String myStderr = "";
    private StreamGobbler myOutputGobbler;
    private StreamGobbler myErrorGobbler;
    private Throwable myException = null;
    private final Charset myEncoding;

    public ExecResult() {
        this(Charset.defaultCharset());
    }

    public ExecResult(Charset charset) {
        this.myEncoding = charset;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ErrCode=");
        buf.append(this.getExitCode());
        buf.append("\nStdOut:------------\n");
        buf.append(this.getStdout());
        buf.append("\nStdErr:------------\n");
        buf.append(this.getStderr());
        if (this.getException() != null) {
            buf.append("\nException----------\n");
            buf.append(this.getException());
        }
        buf.append("\nEnd----------------\n");
        return buf.toString();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void setStdout(String stdout) {
        this.myStdout = stdout;
    }

    public void setStderr(String stderr) {
        this.myStderr = stderr;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getStdout() {
        String string;
        if (this.myOutputGobbler != null) {
            string = this.myOutputGobbler.getReadString(this.myEncoding);
            if (string == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/ExecResult.getStdout must not return null");
            return string;
        }
        string = this.myStdout;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/ExecResult.getStdout must not return null");
    }

    public String[] getOutLines() {
        return this.getStdout().split("\\r?\\n");
    }

    public void setOutputGobbler(StreamGobbler outputGobbler) {
        this.myOutputGobbler = outputGobbler;
    }

    public void setErrorGobbler(StreamGobbler errorGobbler) {
        this.myErrorGobbler = errorGobbler;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getStderr() {
        String string;
        if (this.myErrorGobbler != null) {
            string = this.myErrorGobbler.getReadString(this.myEncoding);
            if (string == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/ExecResult.getStderr must not return null");
            return string;
        }
        string = this.myStderr;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/ExecResult.getStderr must not return null");
    }

    public Throwable getException() {
        return this.myException;
    }

    public void setException(Throwable exception) {
        this.myException = exception;
    }
}

