/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class NetworkUtil {
    private static final Logger LOG = Logger.getInstance((String)NetworkUtil.class.getName());

    private NetworkUtil() {
    }

    public static InetAddress[] getSelfAddresses() throws SocketException {
        ArrayList<InetAddress> selfAddresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                selfAddresses.add(inetAddress);
            }
        }
        LOG.debug("Found Network Interfaces: " + selfAddresses);
        if (selfAddresses.size() == 0) {
            try {
                return new InetAddress[]{InetAddress.getLocalHost()};
            }
            catch (UnknownHostException e) {
                LOG.error((Throwable)e);
            }
        }
        return selfAddresses.toArray(new InetAddress[selfAddresses.size()]);
    }

    public static boolean isPortBusy(int port) {
        return NetworkUtil.isPortBusy("localhost", port, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortBusy(String host, int port, int connectTimeoutMsecs) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), connectTimeoutMsecs);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return true;
    }

    public static int getFreePort(int i) {
        int numIterations = 0;
        int port = i;
        while (NetworkUtil.isPortBusy(port) && numIterations < 3) {
            if (port == 65535) {
                port = 1025;
                ++numIterations;
            }
            ++port;
        }
        if (numIterations == 3) {
            throw new IllegalStateException("Unable to find free port, tried range: 1025 - 65535");
        }
        return port;
    }

    public static String getHostnameFromAddress(String address) {
        try {
            InetAddress iaddr = InetAddress.getByName(address);
            return iaddr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Failed to resolve address " + address + ": " + e.toString());
            return address;
        }
    }
}

