/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.OutputStream;
import jetbrains.buildServer.CommandLineExecutor;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.StreamGobbler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCommandLineProcessRunner {
    private static final Logger LOG = Logger.getInstance((String)SimpleCommandLineProcessRunner.class.getName());

    private SimpleCommandLineProcessRunner() {
    }

    public static ExecResult runCommand(@NotNull GeneralCommandLine commandLine, @Nullable byte[] input) {
        if (commandLine == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommand must not be null");
        }
        return SimpleCommandLineProcessRunner.runCommand(commandLine, input, new RunCommandEventsAdapter());
    }

    public static ExecResult runCommand(GeneralCommandLine commandLine, @Nullable byte[] input, RunCommandEvents eventHandler) {
        return SimpleCommandLineProcessRunner.runCommandSecure(commandLine, commandLine.getCommandLineString(), input, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecResult runCommandSecure(@NotNull GeneralCommandLine commandLine, @NotNull String commandLineToLog, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler) {
        if (commandLine == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommandSecure must not be null");
        }
        if (commandLineToLog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommandSecure must not be null");
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/SimpleCommandLineProcessRunner.runCommandSecure must not be null");
        }
        ExecResult retVal = new ExecResult(commandLine.getCharset());
        LOG.debug("Start process name: " + commandLineToLog);
        try {
            Process proc = commandLine.createProcess();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
            errorGobbler.start();
            outputGobbler.start();
            if (input != null) {
                OutputStream out = proc.getOutputStream();
                try {
                    out.write(input);
                }
                finally {
                    out.close();
                }
            }
            eventHandler.onProcessStarted(proc);
            Integer timeout = eventHandler.getOutputIdleSecondsTimeout();
            if (timeout == null) {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler));
            } else {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler, timeout));
            }
            retVal.setOutputGobbler(outputGobbler);
            retVal.setErrorGobbler(errorGobbler);
            eventHandler.onProcessFinished(proc);
        }
        catch (Throwable e) {
            retVal.setException(e);
        }
        return retVal;
    }

    public static class NoOutputTimeoutRunCommandEventsAdapter
    implements RunCommandEvents {
        public void onProcessStarted(Process ps) {
        }

        public void onProcessFinished(Process ps) {
        }

        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class RunCommandEventsAdapter
    implements RunCommandEvents {
        public void onProcessStarted(Process ps) {
        }

        public void onProcessFinished(Process ps) {
        }

        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return null;
        }
    }

    public static interface RunCommandEvents {
        public void onProcessStarted(Process var1);

        public void onProcessFinished(Process var1);

        @Nullable
        public Integer getOutputIdleSecondsTimeout();
    }
}

