/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;
import jetbrains.buildServer.agent.AgentRuntimeProperties;
import jetbrains.buildServer.agent.impl.XmlRpcAgentLogListener;
import jetbrains.buildServer.agentServer.AgentLogListener;
import jetbrains.buildServer.messages.XStreamUtil;

public class ServerLogger {
    private static ServerLogger ourInstance;
    private final AgentLogListener myLoggingAgent;
    private static final String DEBUG_OUTPUT_DIR;
    private static final boolean DO_OUTPUT;
    private final String myBuildId;
    private final PrintStream myStdErrStream = System.err;
    private static final ThreadLocal ourInsideLogEvent;

    private ServerLogger(String buildId, AgentLogListener server) {
        this.myLoggingAgent = server;
        this.myBuildId = buildId;
        XStreamUtil.createXStream();
    }

    public static synchronized ServerLogger getLoggerInstance(String buildId) {
        return ServerLogger.getLoggerInstance(buildId, AgentRuntimeProperties.getOwnPort());
    }

    public static synchronized ServerLogger getLoggerInstance(String buildId, int port) {
        return ServerLogger.getLoggerInstance(buildId, new XmlRpcAgentLogListener(port));
    }

    public static synchronized ServerLogger getLoggerInstance(String buildId, AgentLogListener agentLogger) {
        if (ourInstance == null) {
            ourInstance = new ServerLogger(buildId, agentLogger);
        }
        return ourInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String messageXml) {
        if (!this.setInsideLogEvent()) {
            return;
        }
        Vector<String> messages = new Vector<String>(1);
        messages.add(messageXml);
        try {
            this.myLoggingAgent.log(this.myBuildId, messages);
            if (DO_OUTPUT) {
                String thName = Thread.currentThread().getName();
                ServerLogger.debug("Sent", thName + ": " + messages);
            }
        }
        catch (Throwable e) {
            try {
                if (DO_OUTPUT) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(out);
                    e.printStackTrace(printStream);
                    printStream.close();
                    ServerLogger.debug("Error", new String(out.toByteArray()));
                    ServerLogger.debug("Error", e.getLocalizedMessage());
                }
            }
            catch (Throwable e1) {
                // empty catch block
            }
            e.printStackTrace(this.myStdErrStream);
        }
        finally {
            this.clearInsideLogEvent();
        }
    }

    private void clearInsideLogEvent() {
        ourInsideLogEvent.set(null);
    }

    private boolean setInsideLogEvent() {
        Boolean current = (Boolean)ourInsideLogEvent.get();
        if (current != null && current.booleanValue()) {
            return false;
        }
        ourInsideLogEvent.set(Boolean.TRUE);
        return true;
    }

    public void flush() {
    }

    public static synchronized void reset() {
        ourInstance = null;
    }

    public static void debug(String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void debug(String prefix, String s) {
        block11: {
            File myFile = new File(new File(DEBUG_OUTPUT_DIR), prefix + AgentRuntimeProperties.getBuildId());
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(myFile.getAbsolutePath(), true);
            fileWriter.write(new Date().getTime() + ": " + s + "\n");
            Object var6_4 = null;
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
                break block11;
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    Object var6_5 = null;
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        return "ServerLogger: " + this.myLoggingAgent;
    }

    static {
        DEBUG_OUTPUT_DIR = System.getProperty("teamcity.debug.out.dir");
        DO_OUTPUT = DEBUG_OUTPUT_DIR != null;
        ourInsideLogEvent = new ThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

