/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jetbrains.buildServer.agent.TestOutputLogger;

public class TestOutputCollector
implements Serializable {
    private final PrintStream myPrintStream;
    private final PrintStream mySavedStream;
    private final boolean myIsOutput;
    private final Map myThreadToTest = new HashMap();
    private final TestOutputLogger myLogger;
    private static final int BUF_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection tests() {
        Map map = this.myThreadToTest;
        synchronized (map) {
            return new ArrayList(this.myThreadToTest.values());
        }
    }

    public TestOutputCollector(TestOutputLogger logger, PrintStream savedStream, boolean isOutput) {
        this.myLogger = logger;
        this.myPrintStream = new PrintStream(new OutputStream(){

            public void write(int b) throws IOException {
                Iterator iterator = TestOutputCollector.this.tests().iterator();
                while (iterator.hasNext()) {
                    TestOutput testOutput = (TestOutput)iterator.next();
                    testOutput.write(b);
                }
            }

            public void write(byte[] b) throws IOException {
                Iterator iterator = TestOutputCollector.this.tests().iterator();
                while (iterator.hasNext()) {
                    TestOutput testOutput = (TestOutput)iterator.next();
                    testOutput.write(b);
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                Iterator iterator = TestOutputCollector.this.tests().iterator();
                while (iterator.hasNext()) {
                    TestOutput testOutput = (TestOutput)iterator.next();
                    testOutput.write(b, off, len);
                }
            }

            public void flush() throws IOException {
                Iterator iterator = TestOutputCollector.this.tests().iterator();
                while (iterator.hasNext()) {
                    TestOutput testOutput = (TestOutput)iterator.next();
                    testOutput.flush();
                }
            }
        });
        this.mySavedStream = savedStream;
        this.myIsOutput = isOutput;
    }

    public PrintStream getSavedStream() {
        return this.mySavedStream;
    }

    public PrintStream getPrintStream() {
        return this.myPrintStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String testName, String flowId) {
        Map map = this.myThreadToTest;
        synchronized (map) {
            this.myThreadToTest.put(Thread.currentThread(), new TestOutput(testName, flowId));
        }
        if (this.myIsOutput) {
            System.out.flush();
            System.setOut(this.getPrintStream());
        } else {
            System.err.flush();
            System.setErr(this.getPrintStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished() {
        Map map;
        try {
            TestOutput currentTest = this.getCurrentTestOutput();
            if (currentTest != null) {
                System.out.flush();
                System.err.flush();
                this.myPrintStream.flush();
                currentTest.flushIfNeeded(true);
            }
            Object var3_2 = null;
            map = this.myThreadToTest;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Map map2 = this.myThreadToTest;
            synchronized (map2) {
                this.myThreadToTest.remove(Thread.currentThread());
            }
            this.reset();
            throw throwable;
        }
        synchronized (map) {
            this.myThreadToTest.remove(Thread.currentThread());
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reset() {
        Map map = this.myThreadToTest;
        synchronized (map) {
            if (this.myThreadToTest.isEmpty()) {
                if (this.myIsOutput) {
                    System.setOut(this.getSavedStream());
                } else {
                    System.setErr(this.getSavedStream());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestOutput getCurrentTestOutput() {
        Map map = this.myThreadToTest;
        synchronized (map) {
            return (TestOutput)this.myThreadToTest.get(Thread.currentThread());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private class TestOutput
    extends OutputStream {
        private final String myTestName;
        private final ByteArrayOutputStream myStream;
        private final String myFlowId;

        private TestOutput(String testName, String flowId) {
            this.myTestName = testName;
            this.myFlowId = flowId;
            this.myStream = new ByteArrayOutputStream();
        }

        public synchronized void write(int b) throws IOException {
            this.myStream.write(b);
            this.flushIfNeeded(false);
        }

        public synchronized void write(byte[] b) throws IOException {
            this.myStream.write(b);
            this.flushIfNeeded(false);
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.myStream.write(b, off, len);
            this.flushIfNeeded(false);
        }

        public void flush() throws IOException {
            this.flushIfNeeded(true);
        }

        public synchronized void flushIfNeeded(boolean force) {
            if (this.myStream.size() > 1024 || force && this.myStream.size() > 0) {
                String out = this.myStream.toString();
                if (TestOutputCollector.this.myIsOutput) {
                    TestOutputCollector.this.myLogger.testStdOut(this.myTestName, this.myFlowId, out);
                } else {
                    TestOutputCollector.this.myLogger.testStdErr(this.myTestName, this.myFlowId, out);
                }
                this.myStream.reset();
            }
        }
    }
}

