/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.buildServer.agentServer.BuildFeatureInfo;
import jetbrains.buildServer.agentServer.BuildRunnerData;
import jetbrains.buildServer.agentServer.VcsChangeConverter;
import jetbrains.buildServer.agentServer.VcsRootEntryConverter;
import jetbrains.buildServer.artifacts.ArtifactDependencyInfo;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.util.Option;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsRootEntry;
import jetbrains.buildServer.xstream.XStreamWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentBuild {
    private final long myBuildId;
    private String myCheckoutDir;
    @NotNull
    private String myBuildTypeId;
    private String myArtifactPaths;
    private boolean myPersonal;
    private boolean myPersonalPatchAvailable;
    private String myAccessCode;
    private CheckoutType myCheckoutType = CheckoutType.MANUAL;
    private final Map<String, String> myServerParameters = new TreeMap<String, String>();
    private final List<VcsRootEntry> myVcsRootEntries = new ArrayList<VcsRootEntry>();
    private final Map<Long, String> myFullCheckoutReasons = new TreeMap<Long, String>();
    private final Map<Long, String> myVcsRootOldRevisions = new TreeMap<Long, String>();
    private final Map<Long, String> myVcsRootCurrentRevisions = new TreeMap<Long, String>();
    private final List<ArtifactDependencyInfo> myArtifactDependencies = new ArrayList<ArtifactDependencyInfo>();
    private final List<VcsChangeInfo> myVcsChanges = new ArrayList<VcsChangeInfo>();
    private final List<VcsChangeInfo> myPersonalVcsChanges = new ArrayList<VcsChangeInfo>();
    private final List<String> myUserBuildParameters = new ArrayList<String>();
    private final Map<Option, Object> myBuildTypeOptions = new HashMap<Option, Object>();
    private String myDefaultCheckoutDirectory;
    private final List<BuildRunnerData> myBuildRunners = new ArrayList<BuildRunnerData>();
    private int myDefaultExecutionTimeout = 0;
    private final List<BuildFeatureInfo> myBuildFeatures = new ArrayList<BuildFeatureInfo>();

    public AgentBuild(long buildId) {
        this.myBuildId = buildId;
    }

    public long getBuildId() {
        return this.myBuildId;
    }

    @NotNull
    public String getBuildTypeId() {
        String string = this.myBuildTypeId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getBuildTypeId must not return null");
        }
        return string;
    }

    public void setBuildTypeId(@NotNull String buildTypeId) {
        if (buildTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setBuildTypeId must not be null");
        }
        this.myBuildTypeId = buildTypeId;
    }

    public void setCheckoutDirectory(@Nullable String checkoutDirectory) {
        this.myCheckoutDir = checkoutDirectory;
    }

    public void setArtifactPaths(String artifactPaths) {
        this.myArtifactPaths = artifactPaths;
    }

    @Nullable
    public String getArtifactPaths() {
        return this.myArtifactPaths;
    }

    public boolean isPersonal() {
        return this.myPersonal;
    }

    public boolean isPersonalPatchAvailable() {
        return this.myPersonalPatchAvailable;
    }

    public void setPersonal(boolean personal) {
        this.myPersonal = personal;
    }

    public void setPersonalPatchAvailable(boolean personalPatchAvailable) {
        this.myPersonalPatchAvailable = personalPatchAvailable;
    }

    public void setBuildTypeOptions(@NotNull Map<Option, Object> options) {
        if (options == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setBuildTypeOptions must not be null");
        }
        this.myBuildTypeOptions.clear();
        this.myBuildTypeOptions.putAll(options);
    }

    public void setDefaultExecutionTimeout(int executionTimeout) {
        this.myDefaultExecutionTimeout = executionTimeout;
    }

    public int getDefaultExecutionTimeout() {
        return this.myDefaultExecutionTimeout;
    }

    @NotNull
    public String getAccessCode() {
        String string = this.myAccessCode;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getAccessCode must not return null");
        }
        return string;
    }

    public void setAccessCode(@NotNull String accessCode) {
        if (accessCode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setAccessCode must not be null");
        }
        this.myAccessCode = accessCode;
    }

    @NotNull
    public CheckoutType getCheckoutType() {
        CheckoutType checkoutType = this.myCheckoutType;
        if (checkoutType == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getCheckoutType must not return null");
        }
        return checkoutType;
    }

    public void setCheckoutType(@NotNull CheckoutType checkoutType) {
        if (checkoutType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setCheckoutType must not be null");
        }
        this.myCheckoutType = checkoutType;
    }

    @NotNull
    public Map<String, String> getServerParameters() {
        Map<String, String> map = this.myServerParameters;
        if (map == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getServerParameters must not return null");
        }
        return map;
    }

    public void setServerParameters(@NotNull Map<String, String> serverParameters) {
        if (serverParameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setServerParameters must not be null");
        }
        this.myServerParameters.clear();
        this.myServerParameters.putAll(serverParameters);
    }

    @NotNull
    public List<VcsRootEntry> getVcsRootEntries() {
        List<VcsRootEntry> list = this.myVcsRootEntries;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getVcsRootEntries must not return null");
        }
        return list;
    }

    public void setVcsRootEntries(@NotNull List<? extends VcsRootEntry> vcsRootEntries) {
        if (vcsRootEntries == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setVcsRootEntries must not be null");
        }
        this.myVcsRootEntries.clear();
        this.myVcsRootEntries.addAll(vcsRootEntries);
    }

    @Nullable
    public String getPreviousRevision(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.getPreviousRevision must not be null");
        }
        return this.myVcsRootOldRevisions.get(vcsRoot.getId());
    }

    public void setPreviousRevision(long vcsRootId, @Nullable String oldRevision) {
        if (oldRevision != null) {
            this.myVcsRootOldRevisions.put(vcsRootId, oldRevision);
        } else {
            this.myVcsRootOldRevisions.remove(vcsRootId);
        }
    }

    @Nullable
    public String getCurrentRevision(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.getCurrentRevision must not be null");
        }
        return this.myVcsRootCurrentRevisions.get(vcsRoot.getId());
    }

    public void setCurrentRevision(long vcsRootId, @Nullable String currentRevision) {
        if (currentRevision != null) {
            this.myVcsRootCurrentRevisions.put(vcsRootId, currentRevision);
        } else {
            this.myVcsRootCurrentRevisions.remove(vcsRootId);
        }
    }

    @Nullable
    public String getFullCheckoutReason(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.getFullCheckoutReason must not be null");
        }
        return this.myFullCheckoutReasons.get(vcsRoot.getId());
    }

    public void setFullCheckoutReason(long vcsRootId, @Nullable String reason) {
        if (reason != null) {
            this.myFullCheckoutReasons.put(vcsRootId, reason);
        } else {
            this.myFullCheckoutReasons.remove(vcsRootId);
        }
    }

    @NotNull
    public List<ArtifactDependencyInfo> getArtifactDependencies() {
        List<ArtifactDependencyInfo> list = this.myArtifactDependencies;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getArtifactDependencies must not return null");
        }
        return list;
    }

    public void setArtifactDependencies(@NotNull List<ArtifactDependencyInfo> artifactDependencies) {
        if (artifactDependencies == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setArtifactDependencies must not be null");
        }
        this.myArtifactDependencies.clear();
        this.myArtifactDependencies.addAll(artifactDependencies);
    }

    @NotNull
    public String getDefaultCheckoutDirectory() {
        String string = this.myDefaultCheckoutDirectory;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getDefaultCheckoutDirectory must not return null");
        }
        return string;
    }

    public void setDefaultCheckoutDirectory(@NotNull String defaultDirNameRelativeToWorkingDir) {
        if (defaultDirNameRelativeToWorkingDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setDefaultCheckoutDirectory must not be null");
        }
        this.myDefaultCheckoutDirectory = defaultDirNameRelativeToWorkingDir.replace(' ', '_').replace(':', ' ');
    }

    @Nullable
    public String getCheckoutDirectory() {
        return this.myCheckoutDir;
    }

    @NotNull
    public List<BuildRunnerData> getBuildRunners() {
        List<BuildRunnerData> list = this.myBuildRunners;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getBuildRunners must not return null");
        }
        return list;
    }

    public void setBuildRunners(@NotNull List<BuildRunnerData> settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setBuildRunners must not be null");
        }
        this.myBuildRunners.clear();
        this.myBuildRunners.addAll(settings);
    }

    public List<BuildFeatureInfo> getBuildFeatures() {
        return this.myBuildFeatures;
    }

    public void setBuildFeatures(@NotNull List<BuildFeatureInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setBuildFeatures must not be null");
        }
        this.myBuildFeatures.clear();
        this.myBuildFeatures.addAll(infos);
    }

    @Nullable
    public <T> T getOptionValue(@NotNull Option<T> option) {
        if (option == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.getOptionValue must not be null");
        }
        Object value = this.myBuildTypeOptions.get(option);
        if (value == null) {
            return option.getDefaultValue();
        }
        return (T)value;
    }

    @NotNull
    public List<VcsChangeInfo> getVcsChanges() {
        List<VcsChangeInfo> list = this.myVcsChanges;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getVcsChanges must not return null");
        }
        return list;
    }

    public void setVcsChanges(@NotNull List<VcsChangeInfo> vcsChanges) {
        if (vcsChanges == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setVcsChanges must not be null");
        }
        this.myVcsChanges.clear();
        this.myVcsChanges.addAll(vcsChanges);
    }

    public void setPersonalVcsChanges(@NotNull List<VcsChangeInfo> vcsChanges) {
        if (vcsChanges == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setPersonalVcsChanges must not be null");
        }
        this.myPersonalVcsChanges.clear();
        this.myPersonalVcsChanges.addAll(vcsChanges);
    }

    public void setUserBuildParameters(@NotNull Collection<String> userDefinedKeys) {
        if (userDefinedKeys == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.setUserBuildParameters must not be null");
        }
        this.myUserBuildParameters.clear();
        this.myUserBuildParameters.addAll(userDefinedKeys);
    }

    @NotNull
    public List<String> getUserBuildParameters() {
        List<String> list = Collections.unmodifiableList(this.myUserBuildParameters);
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getUserBuildParameters must not return null");
        }
        return list;
    }

    @NotNull
    public Collection<String> getUserDefinedReferences() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getReferences(this.myCheckoutDir));
        for (BuildRunnerData runner : this.myBuildRunners) {
            result.addAll(this.getReferences(runner.getRunnerParameters().values()));
        }
        for (VcsRootEntry vre : this.myVcsRootEntries) {
            result.addAll(this.getReferences(vre.getVcsRoot().getProperties().values()));
            result.addAll(this.getReferences(vre.getCheckoutRules().getAsString()));
        }
        for (ArtifactDependencyInfo adi : this.myArtifactDependencies) {
            result.addAll(adi.getReferences());
        }
        result.addAll(this.myUserBuildParameters);
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getUserDefinedReferences must not return null");
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Collection<String> getReferences(String value) {
        Collection<Object> collection;
        if (value == null) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getReferences must not return null");
            return collection;
        }
        collection = ReferencesResolverUtil.getReferences(value);
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getReferences must not return null");
    }

    @NotNull
    private Collection<String> getReferences(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.getReferences must not be null");
        }
        HashSet<String> result = new HashSet<String>();
        for (String value : values) {
            result.addAll(this.getReferences(value));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getReferences must not return null");
        }
        return hashSet;
    }

    @NotNull
    public List<VcsChangeInfo> getPersonalVcsChanges() {
        List<VcsChangeInfo> list = this.myPersonalVcsChanges;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.getPersonalVcsChanges must not return null");
        }
        return list;
    }

    @NotNull
    public String serialize() {
        String string = XStreamWrapper.serializeObject(this, AgentBuild.createXStreamHolder());
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.serialize must not return null");
        }
        return string;
    }

    @NotNull
    public static AgentBuild deserialize(@NotNull String serialized) {
        if (serialized == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/agentServer/AgentBuild.deserialize must not be null");
        }
        AgentBuild agentBuild = (AgentBuild)XStreamWrapper.deserializeObject(serialized, AgentBuild.createXStreamHolder());
        if (agentBuild == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.deserialize must not return null");
        }
        return agentBuild;
    }

    @NotNull
    private static XStreamHolder createXStreamHolder() {
        XStreamHolder xStreamHolder = new XStreamHolder(){

            protected void configureXStream(XStream xStream) {
                xStream.alias("AgentBuild", AgentBuild.class);
                xStream.aliasType("VcsRootEntry", VcsRootEntry.class);
                xStream.alias("ArtifactDependency", ArtifactDependencyInfo.class);
                xStream.aliasType("VcsChange", VcsChangeInfo.class);
                xStream.registerConverter((Converter)new VcsRootEntryConverter());
                xStream.registerConverter((Converter)new VcsChangeConverter());
            }
        };
        if (xStreamHolder == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.createXStreamHolder must not return null");
        }
        return xStreamHolder;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AgentBuild");
        sb.append("{myAccessCode='").append(this.myAccessCode).append('\'');
        sb.append(", myBuildId=").append(this.myBuildId);
        sb.append(", myCheckoutDir='").append(this.myCheckoutDir).append('\'');
        sb.append(", myBuildTypeId='").append(this.myBuildTypeId).append('\'');
        sb.append(", myArtifactPaths='").append(this.myArtifactPaths).append('\'');
        sb.append(", myPersonal=").append(this.myPersonal);
        sb.append(", myCheckoutType=").append((Object)this.myCheckoutType);
        sb.append(", myServerParameters=").append(this.myServerParameters);
        sb.append(", myVcsRootEntries=").append(this.myVcsRootEntries);
        sb.append(", myVcsRootOldRevisions=").append(this.myVcsRootOldRevisions);
        sb.append(", myVcsRootCurrentRevisions=").append(this.myVcsRootCurrentRevisions);
        sb.append(", myArtifactDependencies=").append(this.myArtifactDependencies);
        sb.append(", myVcsChanges=").append(this.myVcsChanges);
        sb.append(", myPersonalVcsChanges=").append(this.myPersonalVcsChanges);
        sb.append(", myUserBuildParameters=").append(this.myUserBuildParameters);
        sb.append(", myBuildTypeOptions=").append(this.myBuildTypeOptions);
        sb.append(", myDefaultExecutionTimeout=").append(this.myDefaultExecutionTimeout);
        sb.append(", myDefaultCheckoutDirectory='").append(this.myDefaultCheckoutDirectory).append('\'');
        sb.append(", myBuildRunners=").append(this.myBuildRunners);
        sb.append(", myBuildFeatures=").append(this.myBuildFeatures);
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/agentServer/AgentBuild.toString must not return null");
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckoutType {
        ON_SERVER,
        ON_AGENT,
        MANUAL;

    }
}

