/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import jetbrains.buildServer.vcs.VcsChange;
import jetbrains.buildServer.vcs.VcsChangeInfo;

public class VcsChangeConverter
implements Converter {
    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        VcsChangeInfo vcsChange = (VcsChangeInfo)o;
        writer.addAttribute("type", vcsChange.getType().name());
        if (vcsChange.getChangeTypeName() != null) {
            writer.addAttribute("changeTypeName", vcsChange.getChangeTypeName());
        }
        if (vcsChange.getBeforeChangeRevisionNumber() != null) {
            writer.addAttribute("beforeRevision", vcsChange.getBeforeChangeRevisionNumber());
        }
        if (vcsChange.getAfterChangeRevisionNumber() != null) {
            writer.addAttribute("afterRevision", vcsChange.getAfterChangeRevisionNumber());
        }
        writer.startNode("fileName");
        writer.setValue(vcsChange.getFileName());
        writer.endNode();
        writer.startNode("relativeFileName");
        writer.setValue(vcsChange.getRelativeFileName());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        VcsChangeInfo.Type changeType = VcsChangeInfo.Type.valueOf(reader.getAttribute("type"));
        String changeTypeName = reader.getAttribute("changeTypeName");
        String beforeRev = reader.getAttribute("beforeRevision");
        String afterRev = reader.getAttribute("afterRevision");
        reader.moveDown();
        String fileName = reader.getValue();
        reader.moveUp();
        reader.moveDown();
        String relativeFileName = reader.getValue();
        reader.moveUp();
        return new VcsChange(changeType, changeTypeName, fileName, relativeFileName, beforeRev, afterRev);
    }

    public boolean canConvert(Class aClass) {
        return VcsChangeInfo.class.isAssignableFrom(aClass);
    }
}

