/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.artifacts.ArtifactDependency;
import jetbrains.buildServer.artifacts.BuildTagRevisionRule;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.artifacts.RevisionRules;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.ValueResolver;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseArtifactDependency
implements ArtifactDependency {
    private String mySourceBuildTypeId;
    private String mySourcePaths;
    private boolean myCleanDestinationFolder = false;
    private RevisionRule myRevisionRule;

    protected BaseArtifactDependency(String sourceBuildTypeId, String sourcePaths, RevisionRule revisionRule) {
        this.mySourceBuildTypeId = sourceBuildTypeId;
        this.mySourcePaths = sourcePaths;
        this.myRevisionRule = revisionRule;
    }

    @Override
    public void setCleanDestinationFolder(boolean cleanDestinationFolder) {
        this.myCleanDestinationFolder = cleanDestinationFolder;
    }

    @Override
    @NotNull
    public String getSourceBuildTypeId() {
        String string = this.mySourceBuildTypeId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/BaseArtifactDependency.getSourceBuildTypeId must not return null");
        }
        return string;
    }

    @Override
    public String getSourcePaths() {
        return this.mySourcePaths;
    }

    @Override
    public boolean isCleanDestinationFolder() {
        return this.myCleanDestinationFolder;
    }

    @Override
    public RevisionRule getRevisionRule() {
        return this.myRevisionRule;
    }

    public String toString() {
        return "build configuration: " + this.mySourceBuildTypeId + "; source path: " + this.mySourcePaths + "; clean destination: " + this.myCleanDestinationFolder + "; revision: " + this.myRevisionRule.getRevision();
    }

    @Override
    public void setSourceBuildTypeId(@NotNull String sourceBuildTypeId) {
        if (sourceBuildTypeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.setSourceBuildTypeId must not be null");
        }
        this.mySourceBuildTypeId = sourceBuildTypeId;
    }

    @Override
    public void setRevisionRule(@NotNull RevisionRule revisionRule) {
        if (revisionRule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.setRevisionRule must not be null");
        }
        this.myRevisionRule = revisionRule;
    }

    @Override
    public void setSourcePaths(@NotNull String paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.setSourcePaths must not be null");
        }
        this.mySourcePaths = paths;
    }

    @Override
    public void replaceReferences(@NotNull ValueResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/BaseArtifactDependency.replaceReferences must not be null");
        }
        String resolvedSourcePaths = this.resolveValue(this.getSourcePaths(), resolver);
        this.setSourcePaths(resolvedSourcePaths);
        RevisionRule revisionRule = this.getRevisionRule();
        if ("buildNumber".equals(revisionRule.getName())) {
            this.setRevisionRule(RevisionRules.newBuildNumberRule(this.resolveValue(revisionRule.getRevision(), resolver)));
        }
        if ("buildTag".equals(revisionRule.getName())) {
            this.setRevisionRule(RevisionRules.newBuildTagRule(this.resolveValue(((BuildTagRevisionRule)revisionRule).getBuildTag(), resolver)));
        }
    }

    private String resolveValue(String value, ValueResolver resolver) {
        return ReferencesResolverUtil.mayContainReference(value) ? resolver.resolve(value).getResult() : value;
    }

    @Override
    public List<String> getReferences() {
        ArrayList<String> refs = new ArrayList<String>();
        refs.addAll(ReferencesResolverUtil.getReferences(this.getRevisionRule().getRevision()));
        refs.addAll(ReferencesResolverUtil.getReferences(this.getSourcePaths()));
        return refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseArtifactDependency that = (BaseArtifactDependency)o;
        if (this.myCleanDestinationFolder != that.myCleanDestinationFolder) {
            return false;
        }
        if (!this.myRevisionRule.equals(that.myRevisionRule)) {
            return false;
        }
        if (!this.mySourceBuildTypeId.equals(that.mySourceBuildTypeId)) {
            return false;
        }
        return this.mySourcePaths.equals(that.mySourcePaths);
    }

    public int hashCode() {
        int result = this.mySourceBuildTypeId.hashCode();
        result = 31 * result + this.mySourcePaths.hashCode();
        result = 31 * result + (this.myCleanDestinationFolder ? 1 : 0);
        result = 31 * result + this.myRevisionRule.hashCode();
        return result;
    }
}

