/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.XmlExternalizable;
import jetbrains.buildServer.artifacts.BuildTagRevisionRule;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.StringUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionRules {
    @NonNls
    public static final String REVISION_RULE_TAG = "revisionRule";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String REVISION_ATTR = "revision";
    public static final String LAST_PINNED_NAME = "lastPinned";
    public static final String LAST_SUCCESSFUL_NAME = "lastSuccessful";
    public static final String LAST_FINISHED_NAME = "lastFinished";
    public static final String LAST_FINISHED_SAME_CHAIN_NAME = "sameChainOrLastFinished";
    public static final String BUILD_NUMBER_NAME = "buildNumber";
    public static final String BUILD_ID_NAME = "buildId";
    public static final String BUILD_TAG_NAME = "buildTag";
    @NotNull
    public static final RevisionRule LAST_PINNED_RULE = new AbstractRevisionRule(){

        public String getRevision() {
            return "latest.lastPinned";
        }

        public String getDescription() {
            return "Last pinned build";
        }

        public String getName() {
            return RevisionRules.LAST_PINNED_NAME;
        }
    };
    @NotNull
    public static final RevisionRule LAST_SUCCESSFUL_RULE = new AbstractRevisionRule(){

        public String getRevision() {
            return "latest.lastSuccessful";
        }

        public String getDescription() {
            return "Last successful build";
        }

        public String getName() {
            return RevisionRules.LAST_SUCCESSFUL_NAME;
        }
    };
    @NotNull
    public static final RevisionRule LAST_FINISHED_RULE = new AbstractRevisionRule(){

        public String getRevision() {
            return "latest.lastFinished";
        }

        public String getDescription() {
            return "Last finished build";
        }

        public String getName() {
            return RevisionRules.LAST_FINISHED_NAME;
        }
    };
    @NotNull
    public static final RevisionRule LAST_FINISHED_SAME_CHAIN_RULE = new AbstractRevisionRule(){

        public String getRevision() {
            return "latest.sameChainOrLastFinished";
        }

        public String getDescription() {
            return "Build from the same chain";
        }

        public String getName() {
            return RevisionRules.LAST_FINISHED_SAME_CHAIN_NAME;
        }
    };
    public static final String BUILD_TAG_SUFFIX = ".tcbuildtag";
    public static final String BUILD_ID_SUFFIX = ".tcbuildid";
    private static final Pattern BUILD_ID_PATTERN = Pattern.compile("([0-9]+)(:id|" + StringUtil.escapeForRegex(".tcbuildid") + ")");

    private RevisionRules() {
    }

    @NotNull
    public static RevisionRule newBuildNumberRule(final String buildNumber) {
        AbstractRevisionRule abstractRevisionRule = new AbstractRevisionRule(){

            public String getRevision() {
                return buildNumber;
            }

            public String getDescription() {
                return "Build #" + this.getRevision();
            }

            public String getName() {
                return RevisionRules.BUILD_NUMBER_NAME;
            }
        };
        if (abstractRevisionRule == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newBuildNumberRule must not return null");
        }
        return abstractRevisionRule;
    }

    @NotNull
    public static RevisionRule newBuildTagRule(@Nullable String buildTagParam) {
        final String buildTag = buildTagParam != null ? (buildTagParam.endsWith(BUILD_TAG_SUFFIX) ? buildTagParam.substring(0, buildTagParam.lastIndexOf(BUILD_TAG_SUFFIX)).trim() : buildTagParam.trim()) : "";
        BuildTagRevisionRule buildTagRevisionRule = new BuildTagRevisionRule(){

            public String getName() {
                return RevisionRules.BUILD_TAG_NAME;
            }

            public String getRevision() {
                return buildTag + RevisionRules.BUILD_TAG_SUFFIX;
            }

            public String getDescription() {
                return "Last build with tag: " + buildTag;
            }

            @NotNull
            public String getBuildTag() {
                String string = buildTag;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules$6.getBuildTag must not return null");
                }
                return string;
            }
        };
        if (buildTagRevisionRule == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newBuildTagRule must not return null");
        }
        return buildTagRevisionRule;
    }

    @NotNull
    public static RevisionRule newBuildIdRule(final long buildId, final @Nullable String buildNumber) {
        AbstractRevisionRule abstractRevisionRule = new AbstractRevisionRule(){

            public String getRevision() {
                return buildId + RevisionRules.BUILD_ID_SUFFIX;
            }

            public String getDescription() {
                if (!StringUtil.isEmptyOrSpaces((String)buildNumber)) {
                    return "Build #" + buildNumber + " [id " + buildId + "]";
                }
                return "Build with id: " + buildId;
            }

            public String getName() {
                return RevisionRules.BUILD_ID_NAME;
            }
        };
        if (abstractRevisionRule == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newBuildIdRule must not return null");
        }
        return abstractRevisionRule;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static RevisionRule newRevisionRule(@NotNull String name, @Nullable String value) {
        RevisionRule revisionRule;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not be null");
        }
        if (LAST_FINISHED_NAME.equals(name)) {
            revisionRule = LAST_FINISHED_RULE;
            if (revisionRule == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not return null");
            return revisionRule;
        }
        if (LAST_FINISHED_SAME_CHAIN_NAME.equals(name)) {
            revisionRule = LAST_FINISHED_SAME_CHAIN_RULE;
            if (revisionRule == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not return null");
            return revisionRule;
        }
        if (LAST_PINNED_NAME.equals(name)) {
            revisionRule = LAST_PINNED_RULE;
            if (revisionRule == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not return null");
            return revisionRule;
        }
        if (LAST_SUCCESSFUL_NAME.equals(name)) {
            revisionRule = LAST_SUCCESSFUL_RULE;
            if (revisionRule == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not return null");
            return revisionRule;
        }
        if (BUILD_TAG_NAME.equals(name)) {
            revisionRule = RevisionRules.newBuildTagRule(value);
            if (revisionRule == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not return null");
            return revisionRule;
        }
        revisionRule = RevisionRules.newBuildNumberRule(value);
        if (revisionRule != null) return revisionRule;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not return null");
    }

    @Nullable
    public static RevisionRule newRevisionRule(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/artifacts/RevisionRules.newRevisionRule must not be null");
        }
        Matcher matcher = BUILD_ID_PATTERN.matcher(revision);
        if (matcher.matches()) {
            String buildIdStr = matcher.group(1);
            try {
                return RevisionRules.newBuildIdRule(Long.parseLong(buildIdStr), null);
            }
            catch (NumberFormatException e) {
                Loggers.SERVER.warn("Failed to parse build id from the revision: " + revision);
                return null;
            }
        }
        if (revision.endsWith(BUILD_TAG_SUFFIX)) {
            return RevisionRules.newBuildTagRule(revision);
        }
        String rev = revision;
        int lastDotIdx = revision.lastIndexOf(46);
        if (lastDotIdx != -1) {
            rev = revision.substring(lastDotIdx);
        }
        for (RevisionRule rule : Arrays.asList(LAST_PINNED_RULE, LAST_FINISHED_RULE, LAST_FINISHED_SAME_CHAIN_RULE, LAST_SUCCESSFUL_RULE)) {
            if (!rule.getRevision().endsWith(rev)) continue;
            return rule;
        }
        return RevisionRules.newBuildNumberRule(revision);
    }

    public static abstract class AbstractRevisionRule
    implements RevisionRule,
    XmlExternalizable {
        public void writeTo(Element parentElement) {
            Element revisionRule = new Element(RevisionRules.REVISION_RULE_TAG);
            parentElement.addContent((Content)revisionRule);
            revisionRule.setAttribute(RevisionRules.NAME_ATTR, this.getName());
            revisionRule.setAttribute(RevisionRules.REVISION_ATTR, this.getRevision());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RevisionRule rule = (RevisionRule)o;
            return this.getName().equals(rule.getName()) && this.getRevision().equals(rule.getRevision());
        }

        public int hashCode() {
            int result = this.getName().hashCode();
            result = 31 * result + this.getRevision().hashCode();
            return result;
        }
    }
}

