/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.ChangeProvider;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.NamedThreadFactory;
import org.jetbrains.annotations.NonNls;

public class ChangeObserver {
    private static final Logger LOG = Logger.getInstance((String)"jetbrains.buildServer.ChangeObserver");
    @NonNls
    private static volatile ScheduledExecutorService ourScheduler;
    private final EventDispatcher<ChangeListener> myListeners = EventDispatcher.create(ChangeListener.class);
    private final List<ChangeProvider> myWatchers = new ArrayList<ChangeProvider>();
    private final AtomicBoolean myStopped = new AtomicBoolean(true);
    private final AtomicBoolean myPaused = new AtomicBoolean(false);
    private String myLastRequestor;
    private long mySleepingPeriod;
    private boolean mySkipListenersNotification;
    private boolean myChangesDetected;

    public ChangeObserver(long intervalForCheckingsMsecs) {
        if (ourScheduler == null || ourScheduler.isShutdown() && LogInitializer.isUnitTest()) {
            ourScheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Change Observer"));
        }
        this.mySleepingPeriod = intervalForCheckingsMsecs;
    }

    public void registerListener(ChangeListener listener) {
        this.myListeners.addListener(listener);
    }

    public void unregisterListener(ChangeListener listener) {
        this.myListeners.removeListener(listener);
    }

    public void registerChangeProvider(ChangeProvider provider) {
        this.myWatchers.add(provider);
    }

    public void unregisterChangeProvider(ChangeProvider provider) {
        this.myWatchers.remove(provider);
    }

    public void start() {
        this.myStopped.set(false);
        this.myPaused.set(false);
        this.scheduleMe();
    }

    public void stop() {
        this.myStopped.set(true);
    }

    public static void shutdownAll() {
        ourScheduler.shutdownNow();
        try {
            ourScheduler.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void setSleepingPeriod(long time) {
        this.mySleepingPeriod = time;
    }

    public long getSleepingPeriod() {
        return this.mySleepingPeriod;
    }

    public void clear() {
        this.myListeners.dispose();
        this.myWatchers.clear();
    }

    public synchronized void setSkipListenersNotification(boolean value) {
        this.mySkipListenersNotification = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runActionWithDisabledObserver(Runnable runnable) {
        boolean oldvalue = this.myPaused.getAndSet(true);
        try {
            runnable.run();
        }
        finally {
            this.resetChanged();
            this.myPaused.set(oldvalue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkForModifications() {
        boolean changesDetected = this.detectChanges();
        if (changesDetected) {
            this.myChangesDetected = true;
            if (this.mySkipListenersNotification) {
                this.resetChanged();
                return;
            }
        }
        if (this.myChangesDetected) {
            try {
                this.myListeners.getMulticaster().changeOccured(this.myLastRequestor);
            }
            finally {
                try {
                    this.resetChanged();
                }
                finally {
                    this.myLastRequestor = null;
                    this.myChangesDetected = false;
                }
            }
        }
    }

    private void scheduleMe() {
        try {
            ourScheduler.schedule(new Runnable(){

                public void run() {
                    try {
                        if (ChangeObserver.this.myStopped.get()) {
                            return;
                        }
                        if (!ChangeObserver.this.myPaused.get()) {
                            ChangeObserver.this.checkForModifications();
                        }
                        ChangeObserver.this.scheduleMe();
                    }
                    catch (Throwable t) {
                        LOG.warn("Change observer task failed: " + t.getMessage(), t);
                    }
                }
            }, this.mySleepingPeriod, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            LOG.info(e.getMessage());
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }

    private void resetChanged() {
        ChangeProvider[] watchers;
        for (ChangeProvider watcher : watchers = this.myWatchers.toArray(new ChangeProvider[this.myWatchers.size()])) {
            watcher.resetChanged();
        }
    }

    private boolean detectChanges() {
        ChangeProvider[] watchers;
        boolean result = false;
        for (ChangeProvider watcher : watchers = this.myWatchers.toArray(new ChangeProvider[this.myWatchers.size()])) {
            if (!watcher.changesDetected()) continue;
            result = true;
            this.myLastRequestor = watcher.getRequestor();
        }
        return result;
    }
}

