/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import java.io.File;

public class WatchedFileState {
    private final boolean myExists;
    private final boolean myIsDirectory;
    private final long myLastModified;
    private final long mySize;

    WatchedFileState(File file) {
        this.myLastModified = file.lastModified();
        boolean bl = this.myExists = this.myLastModified != 0L;
        if (this.myExists) {
            this.mySize = this.getFileSize(file);
            this.myIsDirectory = this.mySize == 0L && file.isDirectory();
        } else {
            this.myIsDirectory = false;
            this.mySize = 0L;
        }
    }

    private long getFileSize(File file) {
        return file.length();
    }

    boolean isCreated(File file) {
        return !this.myExists && file.exists();
    }

    boolean isChanged(File file) {
        boolean fileExists = file.exists();
        if (fileExists != this.myExists) {
            return true;
        }
        if (!fileExists) {
            return false;
        }
        return this.myIsDirectory != file.isDirectory() || this.myLastModified != file.lastModified() || this.mySize != this.getFileSize(file);
    }
}

