/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.duplicator;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.StringTokenizer;

public class DuplicateInfo {
    private Fragment[] myFragments;
    private DuplicateMetrics myMetrics;

    public DuplicateInfo(int hash, int cost, Fragment[] fragments) {
        this.myMetrics = new DuplicateMetrics(hash, cost);
        this.myFragments = fragments;
    }

    public DuplicateMetrics getMetrics() {
        return this.myMetrics;
    }

    public Fragment[] getFragments() {
        return this.myFragments;
    }

    public int getHash() {
        return this.myMetrics.getHash();
    }

    public int getCost() {
        return this.myMetrics.getCost();
    }

    public int getDensity() {
        return this.myFragments.length;
    }

    public String toString() {
        return this.myMetrics.getHash() + ":" + this.myMetrics.getCost() + ":" + this.myFragments.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuplicateInfo that = (DuplicateInfo)o;
        if (!this.myMetrics.equals(that.myMetrics)) {
            return false;
        }
        return Arrays.equals(this.myFragments, that.myFragments);
    }

    public int hashCode() {
        return 31 * this.myMetrics.hashCode() + Arrays.hashCode(this.myFragments);
    }

    public static class LineOffset
    extends FragmentOffset {
        private int myStartLine;
        private int myEndLine;
        public static final String PREFIX = "line:";

        public LineOffset(int startOffset, int endOffset) {
            this.myStartLine = startOffset;
            this.myEndLine = endOffset;
        }

        public LineOffset(String serialized) {
            String withoutPrefix = serialized.substring(PREFIX.length());
            StringTokenizer st = new StringTokenizer(withoutPrefix, ",");
            this.myStartLine = Integer.valueOf(st.nextToken());
            this.myEndLine = Integer.valueOf(st.nextToken());
        }

        public String getAsString() {
            return PREFIX + this.myStartLine + "," + this.myEndLine;
        }

        public String extractFragment(String fileContent) {
            String normalizedContent = StringUtil.convertLineSeparators((String)fileContent);
            int startOffset = 0;
            int endOffset = -1;
            int lineFeed = 0;
            int pos = 0;
            while ((pos = normalizedContent.indexOf(10, pos)) >= 0) {
                ++pos;
                if (++lineFeed == this.myStartLine - 1) {
                    startOffset = pos;
                }
                if (lineFeed != this.myEndLine) continue;
                endOffset = pos - 1;
            }
            if (startOffset < 0 || startOffset > normalizedContent.length()) {
                startOffset = 0;
            }
            if (endOffset <= 0 || endOffset > normalizedContent.length()) {
                endOffset = normalizedContent.length();
            }
            if (endOffset <= startOffset) {
                return "";
            }
            return normalizedContent.substring(startOffset, endOffset);
        }
    }

    public static class CharOffset
    extends FragmentOffset {
        private int myStartOffset;
        private int myEndOffset;
        public static final String PREFIX = "char:";

        public CharOffset(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public CharOffset(String serialized) {
            String withoutPrefix = serialized.substring(PREFIX.length());
            StringTokenizer st = new StringTokenizer(withoutPrefix, ",");
            this.myStartOffset = Integer.valueOf(st.nextToken());
            this.myEndOffset = Integer.valueOf(st.nextToken());
        }

        public String getAsString() {
            return PREFIX + this.myStartOffset + "," + this.myEndOffset;
        }

        public String extractFragment(String fileContent) {
            if (this.myStartOffset < 0 || this.myStartOffset > fileContent.length()) {
                this.myStartOffset = 0;
            }
            if (this.myEndOffset <= 0 || this.myEndOffset > fileContent.length()) {
                this.myEndOffset = fileContent.length();
            }
            return fileContent.substring(this.myStartOffset, this.myEndOffset);
        }
    }

    public static class NormalizedLineEndOffset
    extends FragmentOffset {
        private int myStartOffset;
        private int myEndOffset;
        public static final String PREFIX = "normalizedLE:";

        public NormalizedLineEndOffset(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public NormalizedLineEndOffset(String serialized) {
            String withoutPrefix = serialized.substring(PREFIX.length());
            StringTokenizer st = new StringTokenizer(withoutPrefix, ",");
            this.myStartOffset = Integer.valueOf(st.nextToken());
            this.myEndOffset = Integer.valueOf(st.nextToken());
        }

        public String getAsString() {
            return PREFIX + this.myStartOffset + "," + this.myEndOffset;
        }

        public String extractFragment(String fileContent) {
            String normalizedContent = StringUtil.convertLineSeparators((String)fileContent);
            if (this.myStartOffset < 0 || this.myStartOffset > normalizedContent.length()) {
                this.myStartOffset = 0;
            }
            if (this.myEndOffset <= 0 || this.myEndOffset > normalizedContent.length()) {
                this.myEndOffset = normalizedContent.length();
            }
            return normalizedContent.substring(this.myStartOffset, this.myEndOffset);
        }
    }

    public static abstract class FragmentOffset {
        public abstract String getAsString();

        public abstract String extractFragment(String var1);

        public static FragmentOffset createFromString(String serialized) {
            if (serialized.startsWith("normalizedLE:")) {
                return new NormalizedLineEndOffset(serialized);
            }
            if (serialized.startsWith("char:")) {
                return new CharOffset(serialized);
            }
            if (serialized.startsWith("line:")) {
                return new LineOffset(serialized);
            }
            throw new IllegalArgumentException("Unknown fragment offset format: " + serialized);
        }
    }

    public static class MetricsWithFiles {
        private DuplicateMetrics myMetrics;
        private String[] myFiles;

        public MetricsWithFiles(DuplicateMetrics metrics, String file) {
            this.myMetrics = metrics;
            this.myFiles = new String[]{file};
        }

        public DuplicateMetrics getMetrics() {
            return this.myMetrics;
        }

        public String[] getFiles() {
            return this.myFiles;
        }

        public void addFile(String file) {
            if (ArrayUtil.find((Object[])this.myFiles, (Object)file) == -1) {
                this.myFiles = (String[])ArrayUtil.mergeArrays((Object[])this.myFiles, (Object[])new String[]{file}, String.class);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricsWithFiles that = (MetricsWithFiles)o;
            return !(this.myMetrics == null ? that.myMetrics != null : !this.myMetrics.equals(that.myMetrics));
        }

        public int hashCode() {
            return this.myMetrics != null ? this.myMetrics.hashCode() : 0;
        }
    }

    public static class Fragment {
        private int myHash;
        private int myStartLine;
        private String myFile;
        private String myOffset;

        public Fragment(int hash, String file, int startLine, FragmentOffset offset) {
            this.myHash = hash;
            this.myFile = file;
            this.myStartLine = startLine;
            this.myOffset = offset.getAsString();
        }

        public int getHash() {
            return this.myHash;
        }

        public String getFile() {
            return this.myFile;
        }

        public int getStartLine() {
            return this.myStartLine;
        }

        public String getOffsetInfo() {
            return this.myOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fragment fragment = (Fragment)o;
            if (this.myHash != fragment.myHash) {
                return false;
            }
            if (!this.myFile.equals(fragment.myFile)) {
                return false;
            }
            return this.myOffset.equals(fragment.myOffset);
        }

        public int hashCode() {
            int result = this.myHash;
            result = 31 * result + this.myFile.hashCode();
            result = 31 * result + this.myOffset.hashCode();
            return result;
        }
    }

    public static class DuplicateMetrics {
        private int myHash;
        private int myCost;
        private int myDensity = 1;

        public DuplicateMetrics(int hash, int cost) {
            this.myHash = hash;
            this.myCost = cost;
        }

        public DuplicateMetrics(int hash, int cost, int density) {
            this(hash, cost);
            this.myDensity = density;
        }

        public int getHash() {
            return this.myHash;
        }

        public int getCost() {
            return this.myCost;
        }

        public int getDensity() {
            return this.myDensity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DuplicateMetrics that = (DuplicateMetrics)o;
            if (this.myCost != that.myCost) {
                return false;
            }
            return this.myHash == that.myHash;
        }

        public int hashCode() {
            int result = this.myHash;
            result = 31 * result + this.myCost;
            return result;
        }

        public void incDensity() {
            ++this.myDensity;
        }
    }
}

