/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import jetbrains.buildServer.http.HttpUtil;
import jetbrains.buildServer.util.Interruptable;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jetbrains.annotations.NotNull;

public class ServerStreamProvider
implements Interruptable {
    protected GetMethod myGet;
    private final String myUri;
    private String myUserId;
    private String myPassword;
    private int myConnectionTimeout = 0;
    private boolean myUseProxy = false;
    private String myProxyHost = null;
    private int myProxyPort = -1;
    private boolean myInterrupted = false;

    public ServerStreamProvider(String uri) {
        this.myUri = uri;
    }

    public void setCredentials(String userId, String password) {
        this.myUserId = userId;
        this.myPassword = password;
    }

    public void setProxySettings(boolean useProxy, String proxyHost, int proxyPort) {
        this.myUseProxy = useProxy;
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.myConnectionTimeout = connectionTimeout;
    }

    public void abort() {
        if (this.myGet != null) {
            this.myGet.abort();
            this.myGet = null;
        }
    }

    public void dispose() {
        if (this.myGet != null) {
            this.myGet.releaseConnection();
            this.myGet = null;
        }
    }

    public InputStream getStream() throws IOException {
        URL serverURL = new URL(this.myUri);
        UsernamePasswordCredentials cre = null;
        if (this.myUserId != null && this.myPassword != null) {
            cre = new UsernamePasswordCredentials(this.myUserId, this.myPassword);
        }
        HttpClient client = HttpUtil.createHttpClient(this.myConnectionTimeout, serverURL, cre);
        if (this.myUseProxy) {
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(this.myUri);
            hostConfiguration.setProxy(this.myProxyHost, this.myProxyPort);
            client.setHostConfiguration(hostConfiguration);
        }
        this.myGet = new GetMethod(this.myUri);
        this.myGet.addRequestHeader(new Header("Accept-encoding", "gzip"));
        this.myGet.setDoAuthentication(true);
        try {
            client.executeMethod((HttpMethod)this.myGet);
            StatusLine status = this.myGet.getStatusLine();
            if (status.getStatusCode() != 200) {
                throw new IOException(HttpUtil.composeHttpErrorMessage(status, "Failed to obtain stream from server."));
            }
            return this.doGetStream(this.myGet);
        }
        catch (IOException e) {
            this.myGet.releaseConnection();
            this.myGet = null;
            throw e;
        }
    }

    private InputStream doGetStream(GetMethod get) throws IOException {
        Header contentTypeHeader = get.getResponseHeader("content-encoding");
        if (contentTypeHeader != null && "gzip".equals(contentTypeHeader.getValue())) {
            return new GZIPInputStream(this.wrapStream(get.getResponseBodyAsStream()));
        }
        return this.wrapStream(get.getResponseBodyAsStream());
    }

    private InputStream wrapStream(final @NotNull InputStream original) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/http/ServerStreamProvider.wrapStream must not be null");
        }
        return new InputStream(){

            public int read() throws IOException {
                ServerStreamProvider.this.checkInterrupted();
                return original.read();
            }
        };
    }

    public void interrupt() {
        this.myInterrupted = true;
    }

    private void checkInterrupted() throws IOException {
        if (this.myInterrupted) {
            this.dispose();
            throw new InterruptedIOException("Operation interrupted");
        }
    }
}

