/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import com.intellij.util.PatternUtil;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class CategoryFilter
extends Filter {
    private Pattern myDenyCategory;
    private Level myMaxDenyLevel;

    public int decide(LoggingEvent loggingEvent) {
        try {
            if (this.myDenyCategory != null && this.myDenyCategory.matcher(loggingEvent.getLoggerName()).matches() && this.levelIsDenied(loggingEvent)) {
                return -1;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return 0;
    }

    private boolean levelIsDenied(LoggingEvent loggingEvent) {
        return this.myMaxDenyLevel == null || this.myMaxDenyLevel.isGreaterOrEqual((Priority)loggingEvent.getLevel());
    }

    public void setDenyCategory(String denyCategory) {
        this.myDenyCategory = Pattern.compile(PatternUtil.convertToRegex((String)denyCategory));
    }

    public void setMaxDenyLevel(Level level) {
        this.myMaxDenyLevel = level;
    }
}

