/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import jetbrains.buildServer.log.Log4jFactory;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LogInitializer {
    private static boolean ourInitialized;
    @NonNls
    public static final String LOG4J_CONFIGURATION = "log4j.configuration";
    @NonNls
    public static final String TEAMCITY_LOGS_DIR_PROP = "teamcity_logs";
    @NonNls
    private static final String DEFAULT_LOGS_DIR_PATH = "../logs/";
    @NonNls
    public static final String TEAMCITY_SERVER_LOG4J_XML = "teamcity-server-log4j.xml";
    @NonNls
    public static final String TEAMCITY_AGENT_LOG4J_XML = "teamcity-agent-log4j.xml";
    private static final String MAIN_CATEGORY = "jetbrains.buildServer";

    private LogInitializer() {
    }

    public static void initServerLogging() {
        if (ourInitialized) {
            return;
        }
        LogInitializer.init(LogInitializer.propertyConfigurator(true), LogInitializer.resourceConfigurator(TEAMCITY_SERVER_LOG4J_XML));
        ourInitialized = true;
        Loggers.SERVER.info("\n\n\n\n\n\n");
        Loggers.SERVER.info("===========================================================");
        Loggers.SERVER.info("Starting TeamCity server");
    }

    public static void initAgentLogging() {
        if (ourInitialized) {
            return;
        }
        LogInitializer.init(LogInitializer.propertyConfigurator(true), LogInitializer.resourceConfigurator(TEAMCITY_AGENT_LOG4J_XML));
        ourInitialized = true;
        Loggers.SERVER.info("Starting TeamCity agent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(LogConfigurator ... configurators) {
        if (configurators == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.init must not be null");
        }
        try {
            LogInitializer.setupLogsDirectoryProperty();
            for (LogConfigurator conf : configurators) {
                if (!conf.configure()) continue;
                return;
            }
        }
        catch (NowhereToLogException ntle) {
            LogInitializer.writeToStdError("Could not initialize logging directory. Logging into the standard console output.");
            LogInitializer.removeAllAppenders();
            LogInitializer.addConsoleAppender();
        }
        finally {
            LogInitializer.postInitActions();
        }
    }

    private static void postInitActions() {
        LogInitializer.initializeIdeaLogging();
    }

    private static void initializeIdeaLogging() {
        com.intellij.openapi.diagnostic.Logger.setFactory((Logger.Factory)new Log4jFactory());
    }

    public static LogConfigurator fileConfigurator(final @NotNull File file, final boolean watchForChanges) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.fileConfigurator must not be null");
        }
        return new LogConfigurator(){

            public boolean configure() {
                if (!file.isFile()) {
                    return false;
                }
                if (watchForChanges) {
                    int secs = 10;
                    DOMConfigurator.configureAndWatch((String)file.getAbsolutePath(), (long)10000L);
                    System.out.println("Log4J configuration file " + file.getAbsolutePath() + " will be monitored with interval " + 10 + " seconds.");
                } else {
                    DOMConfigurator.configure((String)file.getAbsolutePath());
                }
                return true;
            }
        };
    }

    public static LogConfigurator resourceConfigurator(final String ... resources) {
        if (resources == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.resourceConfigurator must not be null");
        }
        return new LogConfigurator(){

            public boolean configure() {
                boolean configured = false;
                for (String res : resources) {
                    URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(res);
                    if (resourceUrl == null) continue;
                    DOMConfigurator.configure((URL)resourceUrl);
                    configured = true;
                }
                return configured;
            }
        };
    }

    public static LogConfigurator propertyConfigurator(final boolean watchForFileChanges) {
        return new LogConfigurator(){

            public boolean configure() {
                String log4jUrl = TeamCityProperties.getPropertyOrNull(LogInitializer.LOG4J_CONFIGURATION);
                if (log4jUrl == null) {
                    return false;
                }
                try {
                    URL url = new URL(log4jUrl);
                    File file = new File(url.getPath());
                    if (!file.isFile()) {
                        LogInitializer.writeToStdError("Specified log4j configuration file (" + log4jUrl + ") not found.");
                        System.setProperty(LogInitializer.LOG4J_CONFIGURATION, "");
                        return false;
                    }
                    if (!LogInitializer.checkTeamCityLog4jConfig(file)) {
                        LogInitializer.writeToStdError("Specified log4j configuration file (" + log4jUrl + ") does not have TeamCity categories, file skipped.");
                        return false;
                    }
                    return LogInitializer.fileConfigurator(file, watchForFileChanges).configure();
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            }
        };
    }

    private static boolean checkTeamCityLog4jConfig(File file) {
        try {
            String configTxt = new String(LogInitializer.loadTextFile(file));
            return configTxt.indexOf(MAIN_CATEGORY) != -1;
        }
        catch (IOException e) {
            LogInitializer.writeToStdError("Failed to load log4j configuration file: " + file + ", error: " + e.toString());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] loadTextFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.loadTextFile must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            char[] cArray = FileUtil.loadText((Reader)reader, (int)((int)file.length()));
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private static void writeToStdError(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.writeToStdError must not be null");
        }
        System.err.println(text);
    }

    private static void writeToStdOut(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.writeToStdOut must not be null");
        }
        System.out.println(text);
    }

    private static void setupLogsDirectoryProperty() throws NowhereToLogException {
        String logsProperty = TeamCityProperties.getProperty(TEAMCITY_LOGS_DIR_PROP, DEFAULT_LOGS_DIR_PATH);
        File logsDirectory = new File(logsProperty);
        boolean logsDirIsOK = LogInitializer.tryToUseLogsDirectory(logsDirectory, "logs directory");
        if (!logsDirIsOK) {
            logsDirectory = new File(DEFAULT_LOGS_DIR_PATH);
            logsDirectory = LogInitializer.resolvePath(logsDirectory);
            logsProperty = logsDirectory.getAbsolutePath();
            logsDirIsOK = LogInitializer.tryToUseLogsDirectory(logsDirectory, "default logs directory");
            if (logsDirIsOK) {
                LogInitializer.writeToStdOut("Using logs directory " + logsDirectory.getAbsolutePath());
            }
        }
        if (!logsDirIsOK) {
            throw new NowhereToLogException();
        }
        if (!logsProperty.endsWith(File.separator)) {
            logsProperty = logsProperty + File.separator;
        }
        System.setProperty(TEAMCITY_LOGS_DIR_PROP, logsProperty);
    }

    private static File resolvePath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.resolvePath must not be null");
        }
        try {
            File resolvedPath = path.getCanonicalFile();
            return resolvedPath;
        }
        catch (Exception e) {
            LogInitializer.writeToStdError("Could not resilve path " + path + '\n' + e.getMessage());
            return path;
        }
    }

    private static boolean tryToUseLogsDirectory(File logsDirectory, String dirDescriptionInfix) {
        logsDirectory.mkdirs();
        if (!logsDirectory.isDirectory()) {
            LogInitializer.writeToStdError("Failed to create the " + dirDescriptionInfix + " " + LogInitializer.getCanonicalFile(logsDirectory));
            return false;
        }
        if (!LogInitializer.checkDirectoryIsWriteable(logsDirectory)) {
            LogInitializer.writeToStdError("The " + dirDescriptionInfix + " " + LogInitializer.getCanonicalFile(logsDirectory) + " is not writeable.");
            return false;
        }
        return true;
    }

    private static File getCanonicalFile(File logsDirectory) {
        try {
            return logsDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            return logsDirectory.getAbsoluteFile();
        }
    }

    private static boolean checkDirectoryIsWriteable(File dir) {
        try {
            File testFile = new File(dir, "testfile.txt");
            if (testFile.exists()) {
                testFile.delete();
            }
            LogInitializer.writeFileAndReportErrorSafe(testFile, "This file was created just to ensure that the directory is writeable.\nNo problem to delete this file.\n");
            boolean ok = testFile.exists() && testFile.isFile();
            testFile.delete();
            return ok;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileAndReportErrorSafe(@NotNull File testFile, @NotNull String text) throws IOException {
        if (testFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.writeFileAndReportErrorSafe must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/log/LogInitializer.writeFileAndReportErrorSafe must not be null");
        }
        FileWriter fileWriter = new FileWriter(testFile);
        try {
            fileWriter.write(text);
        }
        finally {
            fileWriter.close();
        }
    }

    public static boolean isUnitTest() {
        return "yes".equals(System.getProperty("jetbrains.unit.test"));
    }

    public static void setUnitTest(boolean enable) {
        if (enable) {
            System.setProperty("jetbrains.unit.test", "yes");
            LogInitializer.init(LogInitializer.resourceConfigurator("teamcity-tests-log4j.xml"));
            ourInitialized = true;
        } else {
            System.setProperty("jetbrains.unit.test", "no");
        }
    }

    public static void addConsoleAppender() {
        for (Logger logger : LogInitializer.debugLoggers()) {
            logger.addAppender((Appender)LogInitializer.createConsoleAppender());
        }
    }

    public static void removeAllAppenders() {
        for (Logger logger : LogInitializer.debugLoggers()) {
            logger.removeAllAppenders();
        }
    }

    private static Logger[] debugLoggers() {
        return new Logger[]{Logger.getRootLogger(), Logger.getLogger((String)"jetbrains.buildServer.buildTriggers.vcs"), Logger.getLogger((String)"jetbrains.buildServer.VCS")};
    }

    private static ConsoleAppender createConsoleAppender() {
        return new ConsoleAppender((Layout)new PatternLayout("[%d{ABSOLUTE}] %6p - %20.20c [%t] %m \n"));
    }

    public static void enableDebug() {
        Logger.getLogger((String)MAIN_CATEGORY).setLevel(Level.DEBUG);
        Loggers.VCS.setLevel(Level.DEBUG);
    }

    public static void disableDebug() {
        Logger.getLogger((String)MAIN_CATEGORY).setLevel(Level.INFO);
        Loggers.VCS.setLevel(Level.INFO);
    }

    static {
        LogInitializer.initializeIdeaLogging();
    }

    static class NowhereToLogException
    extends Exception {
        NowhereToLogException() {
        }
    }

    public static interface LogConfigurator {
        public boolean configure();
    }
}

