/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;
import jetbrains.buildServer.messages.MemoryOptimizedXmlFriendlyReplacer;
import jetbrains.buildServer.messages.XStreamUtil;
import jetbrains.buildServer.messages.XStreamWrapper;

public class XStreamHolder {
    private final LinkedList myFreeXStream = new LinkedList();
    public static final String UTF_8 = "UTF-8";

    public XStream getXStream() {
        return this.getXStream(null);
    }

    public XStream getXStream(ClassLoader classLoader) {
        XStreamWrapper xs = this.getXStreamInternal();
        xs.setNewClassloader(classLoader);
        return xs;
    }

    public synchronized void releaseXStream(XStream xstream) {
        if (xstream instanceof XStreamWrapper) {
            ((XStreamWrapper)xstream).revertClassloader();
            this.myFreeXStream.add(xstream);
        }
    }

    protected void configureXStream(XStream xStream) {
    }

    private synchronized XStreamWrapper getXStreamInternal() {
        if (this.myFreeXStream.isEmpty()) {
            return this.createXStreamInstance();
        }
        return (XStreamWrapper)((Object)this.myFreeXStream.remove(0));
    }

    private XStreamWrapper createXStreamInstance() {
        XppDriver driver = new XppDriver(new MemoryOptimizedXmlFriendlyReplacer()){

            public HierarchicalStreamReader createReader(InputStream in) {
                try {
                    return this.createReader(new InputStreamReader(in, XStreamHolder.UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    return super.createReader(in);
                }
            }

            public HierarchicalStreamWriter createWriter(OutputStream out) {
                try {
                    return new CompactWriter((Writer)new OutputStreamWriter(out, XStreamHolder.UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    return new CompactWriter((Writer)new OutputStreamWriter(out));
                }
            }
        };
        XStreamWrapper xStream = XStreamUtil.createXStreamInternal((HierarchicalStreamDriver)driver);
        this.configureXStream(xStream);
        return xStream;
    }
}

