/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends MessageWithAttributes {
    Message() {
    }

    public Message(@NotNull String text, @NotNull String status, @Nullable String errDetails) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/Message.<init> must not be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/Message.<init> must not be null");
        }
        super("message", Message.createMap(text, status, errDetails));
    }

    private static Map<String, String> createMap(@NotNull String text, @NotNull String status, @Nullable String errDetails) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/Message.createMap must not be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/Message.createMap must not be null");
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put("text", text);
        res.put("status", status);
        if (errDetails != null) {
            res.put("errorDetails", errDetails);
        }
        return res;
    }

    public String getStatus() {
        String status = this.getAttributeValue("status");
        if (status != null) {
            return status;
        }
        return "NORMAL";
    }

    public String getText() {
        return this.getAttributeValue("text");
    }

    public String getErrorDetails() {
        return this.getAttributeValue("errorDetails");
    }

    @Override
    public void visit(@NotNull ServiceMessageVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/Message.visit must not be null");
        }
        visitor.visitMessageWithStatus(this);
    }
}

