/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.MapParametersProvider;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.impl.CompositeParametersProviderImpl;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;

public class ParametersInOut {
    private final String myName;
    private final MapParametersProvider myPartlyResolved;
    private final MapParametersProvider myFullyResolved;
    private final MapParametersProvider myUnresolved;
    private final ParametersProvider myNotFullyResolved;

    public ParametersInOut(@NotNull String name, @NotNull ParametersProvider original, @NotNull jetbrains.buildServer.parameters.impl.ParametersProviderFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.<init> must not be null");
        }
        if (original == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.<init> must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.<init> must not be null");
        }
        this.myName = name;
        this.myPartlyResolved = factory.getParametersProvider();
        this.myFullyResolved = factory.getParametersProvider();
        this.myUnresolved = factory.getParametersProvider();
        this.myUnresolved.putAll(original.getAll());
        CompositeParametersProviderImpl notFullyResolved = new CompositeParametersProviderImpl();
        notFullyResolved.appendParametersProvider(this.myPartlyResolved);
        notFullyResolved.appendParametersProvider(this.myUnresolved);
        this.myNotFullyResolved = notFullyResolved;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public ParametersProvider getUnresolved() {
        MapParametersProvider mapParametersProvider = this.myUnresolved;
        if (mapParametersProvider == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.getUnresolved must not return null");
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getFullyResolved() {
        MapParametersProvider mapParametersProvider = this.myFullyResolved;
        if (mapParametersProvider == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.getFullyResolved must not return null");
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getPartlyResolved() {
        MapParametersProvider mapParametersProvider = this.myPartlyResolved;
        if (mapParametersProvider == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.getPartlyResolved must not return null");
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getNotFullyResolved() {
        ParametersProvider parametersProvider = this.myNotFullyResolved;
        if (parametersProvider == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.getNotFullyResolved must not return null");
        }
        return parametersProvider;
    }

    int resolveParametersInSinglePass(@NotNull ParametersProvider dictionary, @NotNull ParameterResolver processor) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.resolveParametersInSinglePass must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.resolveParametersInSinglePass must not be null");
        }
        int resolvedCount = 0;
        for (Map.Entry<String, String> parameter : this.getNotFullyResolved().getAll().entrySet()) {
            String key = parameter.getKey();
            String value = parameter.getValue();
            assert (key != null) : "Parameter has null key. Value='" + value + "'";
            assert (value != null) : "Parameter with key='" + key + "'has null value.";
            ProcessingResult evalResult = processor.resolve(key, value, dictionary);
            if (evalResult.isFullyResolved()) {
                this.markAsFullyResolved(key, evalResult.getResult());
                ++resolvedCount;
                continue;
            }
            if (!evalResult.isModified()) continue;
            this.markAsPartlyResolved(key, evalResult.getResult());
        }
        return resolvedCount;
    }

    void resolvingFinished() {
        for (MapParametersProvider provider : Arrays.asList(this.myFullyResolved, this.myPartlyResolved, this.myUnresolved)) {
            HashMap<String, String> allParams = new HashMap<String, String>(provider.getAll());
            for (Map.Entry entry : allParams.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                entry.setValue(ReferencesResolverUtil.unescape(value));
            }
            provider.putAll(allParams);
        }
    }

    public void markAsFullyResolved(@NotNull String key, @NotNull String resolvedValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.markAsFullyResolved must not be null");
        }
        if (resolvedValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.markAsFullyResolved must not be null");
        }
        this.myFullyResolved.put(key, resolvedValue);
        this.myUnresolved.remove(key);
        this.myPartlyResolved.remove(key);
    }

    public void markAsPartlyResolved(@NotNull String key, @NotNull String partlyResolvedValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.markAsPartlyResolved must not be null");
        }
        if (partlyResolvedValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.markAsPartlyResolved must not be null");
        }
        this.myPartlyResolved.put(key, partlyResolvedValue);
        this.myUnresolved.remove(key);
    }

    @NotNull
    public ParametersProvider getAllParameters() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        result.appendParametersProvider(this.myFullyResolved);
        result.appendParametersProvider(this.myPartlyResolved);
        result.appendParametersProvider(this.myUnresolved);
        CompositeParametersProviderImpl compositeParametersProviderImpl = result;
        if (compositeParametersProviderImpl == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.getAllParameters must not return null");
        }
        return compositeParametersProviderImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ProcessingResult createProcessingResult(@NotNull String key, @NotNull String origValue) {
        ProcessingResultImpl processingResultImpl;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.createProcessingResult must not be null");
        }
        if (origValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/parameters/impl/ParametersInOut.createProcessingResult must not be null");
        }
        String resultValue = this.myFullyResolved.get(key);
        if (resultValue == null) {
            String partlyResolved = this.myPartlyResolved.get(key);
            if (partlyResolved == null) {
                partlyResolved = this.myUnresolved.get(key);
            }
            assert (partlyResolved != null);
            processingResultImpl = new ProcessingResultImpl(partlyResolved, !origValue.equals(partlyResolved), false);
            if (processingResultImpl == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.createProcessingResult must not return null");
            return processingResultImpl;
        }
        processingResultImpl = new ProcessingResultImpl(resultValue, !origValue.equals(resultValue), true);
        if (processingResultImpl != null) return processingResultImpl;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/parameters/impl/ParametersInOut.createProcessingResult must not return null");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name: ").append(this.getName()).append(",  ");
        result.append("unresolved: ").append(this.getNotFullyResolved()).append(",  ");
        result.append("partly resolved: ").append(this.getPartlyResolved());
        result.append("fully resolved: ").append(this.getFullyResolved());
        return result.toString();
    }

    @Deprecated
    public static interface ParametersProviderFactory
    extends jetbrains.buildServer.parameters.impl.ParametersProviderFactory {
    }
}

