/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.requirements;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.requirements.Requirement;
import jetbrains.buildServer.requirements.RequirementType;
import org.jdom.Element;

public class RequirementRegistry {
    private final Map<String, RequirementType> myRegisteredFactories = new HashMap<String, RequirementType>();
    private static final RequirementRegistry ourInstance = new RequirementRegistry();

    public static RequirementRegistry getRegistry() {
        return ourInstance;
    }

    public void register(RequirementType factory) {
        this.myRegisteredFactories.put(factory.getName(), factory);
    }

    public Requirement read(Element element) {
        String name = element.getName();
        if (name != null && this.myRegisteredFactories.containsKey(name)) {
            RequirementType factory = this.myRegisteredFactories.get(name);
            return factory.readFrom(element);
        }
        return null;
    }

    static {
        for (RequirementType reqType : RequirementType.ALL_REQUIREMENT_TYPES) {
            RequirementRegistry.getRegistry().register(reqType);
        }
    }
}

