/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.crypt;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class EncryptUtil {
    private static final Logger LOG = Logger.getInstance((String)EncryptUtil.class.getName());
    private static String myScrambledEmptyString;
    private static final byte[] data;
    private static final String ourScrambledPrefix = "zxx";

    public static String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return EncryptUtil.toHex(md.digest(str.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Failed to obtain MD5 algorithm: " + e.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        return str;
    }

    public static String toHex(byte[] bytes) {
        return new String(Hex.encodeHex((byte[])bytes));
    }

    public static byte[] fromHex(String hex) {
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    private static String unscrambleValue(String scrambled, byte[] secretKey) throws CannotBeUnscrambledException {
        if (!scrambled.startsWith(ourScrambledPrefix)) {
            throw new CannotBeUnscrambledException();
        }
        if ((scrambled.length() - ourScrambledPrefix.length()) % 2 != 0) {
            throw new CannotBeUnscrambledException();
        }
        String toDecrypt = scrambled.substring(ourScrambledPrefix.length());
        try {
            String result = new String(EncryptUtil.encryptOrDecrypt(2, EncryptUtil.fromHex(toDecrypt), secretKey), "UTF-8");
            if (result.length() != 0 || EncryptUtil.scrambledEmptyString().equals(scrambled)) {
                return result;
            }
            throw new CannotBeUnscrambledException();
        }
        catch (Throwable e) {
            throw new CannotBeUnscrambledException(e.toString());
        }
    }

    public static boolean isScrambled(String scrambled) {
        try {
            EncryptUtil.unscrambleValue(scrambled, data);
            return true;
        }
        catch (CannotBeUnscrambledException e) {
            return false;
        }
    }

    private static synchronized String scrambledEmptyString() {
        if (myScrambledEmptyString != null) {
            return myScrambledEmptyString;
        }
        myScrambledEmptyString = EncryptUtil.scramble("");
        return myScrambledEmptyString;
    }

    public static String unscramble(String scrambled) throws IllegalArgumentException {
        try {
            return EncryptUtil.unscrambleValue(scrambled, data);
        }
        catch (CannotBeUnscrambledException e) {
            throw new IllegalArgumentException("Cannot unscramble the specified string");
        }
    }

    private static String scrambleValue(String value, byte[] secretKey) {
        try {
            return ourScrambledPrefix + EncryptUtil.toHex(EncryptUtil.encryptOrDecrypt(1, value.getBytes("UTF-8"), secretKey));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String scramble(String value) {
        return EncryptUtil.scrambleValue(value, data);
    }

    private static byte[] encryptOrDecrypt(int mode, byte[] bytes, byte[] secretKey) throws InvalidKeyException, IOException {
        Cipher cipher = EncryptUtil.getCipher(mode, secretKey);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, cipher);
        ((OutputStream)cOut).write(bytes);
        ((OutputStream)cOut).close();
        return bOut.toByteArray();
    }

    public static Cipher getCipher(int mode, byte[] secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(mode, EncryptUtil.getKey(secretKey));
            return cipher;
        }
        catch (Throwable e) {
            throw new RuntimeException("DES-EDE encryption is not supported by this Java installation", e);
        }
    }

    private static SecretKey getKey(byte[] secretKey) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            return keyFactory.generateSecret(new DESedeKeySpec(secretKey));
        }
        catch (Throwable e) {
            throw new RuntimeException("DES-EDE encryption is not supported by this Java installation", e);
        }
    }

    static {
        data = new byte[]{61, 22, 11, 57, 110, 89, -20, -1, 0, 99, 111, -120, 55, 4, -9, 10, 11, 45, 71, -89, 21, -99, 54, 51};
    }

    private static class CannotBeUnscrambledException
    extends Exception {
        private CannotBeUnscrambledException() {
        }

        private CannotBeUnscrambledException(String message) {
            super(message);
        }
    }
}

