/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.crypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import jetbrains.buildServer.serverSide.crypt.DecryptionFailedException;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.serverSide.crypt.EncryptionFailedException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RSACipher {
    private static final Logger LOG = Logger.getLogger(RSACipher.class);
    private static KeyPair ourKeys;
    private static Cipher ourCipher;

    private RSACipher() {
    }

    public static synchronized void generateKeys() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            SecureRandom random = new SecureRandom();
            random.setSeed(System.currentTimeMillis());
            keyGen.initialize(new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4), random);
            ourKeys = keyGen.generateKeyPair();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void prepareCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            ourCipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (NoSuchPaddingException e) {
        }
        finally {
            if (ourCipher == null) {
                try {
                    ourCipher = Cipher.getInstance("RSA", "SunJCE");
                }
                catch (NoSuchProviderException e) {
                    ourCipher = Cipher.getInstance("RSA");
                }
            }
        }
    }

    private static Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return ourCipher;
    }

    private static synchronized KeyPair getKeys() {
        if (ourKeys == null) {
            RSACipher.generateKeys();
        }
        return ourKeys;
    }

    public static String decryptData(String hexEncoded) throws DecryptionFailedException {
        try {
            return new String(RSACipher.decrypt(hexEncoded), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DecryptionFailedException(e);
        }
    }

    @Nullable
    public static String decryptWebRequestData(String hexEncoded) throws DecryptionFailedException {
        byte[] data = RSACipher.decrypt(hexEncoded);
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        try {
            byte length = data[data.length - 1];
            String decrypted = new String(data, 0, data.length - 1, "ISO-8859-1");
            if (decrypted.length() == length) {
                return decrypted;
            }
            decrypted = new String(data, 0, data.length - 1, "UTF-8");
            if (decrypted.length() == length) {
                return decrypted;
            }
            decrypted = new String(data, 0, data.length - 1, "UTF-16");
            if (decrypted.length() != length) {
                throw new DecryptionFailedException("Failed to decrypt data");
            }
            return decrypted;
        }
        catch (UnsupportedEncodingException e) {
            throw new DecryptionFailedException(e);
        }
    }

    @Nullable
    private static byte[] decrypt(String hexEncoded) {
        if (hexEncoded == null) {
            return null;
        }
        try {
            return RSACipher.encryptOrDecrypt(2, RSACipher.getKeys().getPrivate(), EncryptUtil.fromHex(hexEncoded));
        }
        catch (Exception e) {
            throw new DecryptionFailedException(e);
        }
    }

    @Nullable
    public static String encryptData(String plain) throws EncryptionFailedException {
        return RSACipher.encryptData(plain, RSACipher.getKeys().getPublic());
    }

    public static String encryptDataForWeb(String plain) throws EncryptionFailedException {
        if (plain == null) {
            return null;
        }
        try {
            byte[] dataBytes = plain.getBytes("UTF-8");
            int length = dataBytes.length;
            byte[] bytes = new byte[length + 1];
            System.arraycopy(dataBytes, 0, bytes, 0, length);
            bytes[length] = (byte)plain.length();
            return RSACipher.encryptBytes(bytes, RSACipher.getKeys().getPublic());
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionFailedException(e);
        }
    }

    @Nullable
    public static String encryptData(String plain, PublicKey pubKey) throws EncryptionFailedException {
        if (plain == null) {
            return null;
        }
        return RSACipher.encryptBytes(plain.getBytes(), pubKey);
    }

    @Nullable
    private static String encryptBytes(byte[] bytes, PublicKey pubKey) throws EncryptionFailedException {
        if (bytes == null) {
            return null;
        }
        try {
            byte[] data = RSACipher.encryptOrDecrypt(1, pubKey, bytes);
            return EncryptUtil.toHex(data);
        }
        catch (Exception e) {
            throw new EncryptionFailedException(e);
        }
    }

    private static synchronized byte[] encryptOrDecrypt(int mode, Key key, byte[] data) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher rsa = RSACipher.getCipher();
        rsa.init(mode, key);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, rsa);
        ((OutputStream)cOut).write(data);
        ((OutputStream)cOut).close();
        return bOut.toByteArray();
    }

    public static String getHexEncodedPublicKey() {
        RSAPublicKey pubKey = (RSAPublicKey)RSACipher.getKeys().getPublic();
        return EncryptUtil.toHex(pubKey.getModulus().toByteArray());
    }

    public static String getHexEncodedPublicKeyExponent() {
        RSAPublicKey pubKey = (RSAPublicKey)RSACipher.getKeys().getPublic();
        return EncryptUtil.toHex(pubKey.getPublicExponent().toByteArray());
    }

    public static PublicKey recreateKey(String hexModulus, String hexExponent) throws InvalidKeyException {
        try {
            BigInteger modulus = new BigInteger(Hex.decodeHex((char[])hexModulus.toCharArray()));
            BigInteger exponent = new BigInteger(Hex.decodeHex((char[])hexExponent.toCharArray()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (DecoderException e) {
            throw new InvalidKeyException("Failed to decode from hex: " + e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e.toString());
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    static {
        try {
            RSACipher.prepareCipher();
        }
        catch (Throwable e) {
            LOG.error((Object)("Failed to initialize jetbrains.buildServer.serverSide.crypt.RSACipher class: " + e.getMessage()), e);
            throw new RuntimeException(e);
        }
    }
}

