/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide.statistics.impl;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnitudeNumberFormat
extends NumberFormat {
    private final boolean divideByMagnitude = true;
    private final Class<? extends Format> myFormatClass;
    private final double[] myRanges;
    private final String[] myPatterns;
    private final Format[] myFormats;

    public MagnitudeNumberFormat(Class<? extends Format> aClass, double[] ranges, String[] patterns) {
        this.myFormatClass = aClass;
        this.myRanges = ranges;
        this.myPatterns = patterns;
        this.myFormats = new Format[patterns.length];
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number == 0.0) {
            return new StringBuffer("0");
        }
        for (int i = 0; i < this.myRanges.length; ++i) {
            if (!(number < this.myRanges[i])) continue;
            if (i > 0) {
                number /= this.myRanges[i - 1];
            }
            return this.getFormat(i).format(number, toAppendTo, pos);
        }
        return this.getFormat(this.myPatterns.length - 1).format(number /= this.myRanges[this.myRanges.length - 1], toAppendTo, pos);
    }

    private Format getFormat(int i) {
        try {
            if (this.myFormats[i] == null) {
                this.myFormats[i] = this.myFormatClass.getConstructor(String.class).newInstance(this.myPatterns[i]);
            }
            return this.myFormats[i];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }
}

